/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lonelycoders.ufohippa.client.lobby.model.BasicSettings;
import lonelycoders.ufohippa.client.lobby.model.PlayerInfo;

public class AllMatchSettings {
    private BasicSettings basicSettings = new BasicSettings();
    private final List<String> levels = new ArrayList<String>();
    private final List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    private final Collection<Listener> listeners = new HashSet<Listener>();

    public void setBasicSettings(BasicSettings basicSettings) {
        this.basicSettings = basicSettings;
        this.fireBasicSettingsChanged();
    }

    public void setLevels(String[] levelNames) {
        this.levels.clear();
        this.levels.addAll(Arrays.asList(levelNames));
        this.fireLevelSettingsChanged();
    }

    public void setPlayers(PlayerInfo[] players) {
        this.players.clear();
        this.players.addAll(Arrays.asList(players));
        this.firePlayersSettingsChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        this.fireBasicSettingsChanged(listener);
        this.fireLevelSettingsChanged(listener);
        this.firePlayersSettingsChanged(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireBasicSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.fireBasicSettingsChanged(listener);
        }
    }

    private void fireBasicSettingsChanged(Listener listener) {
        listener.basicSettingsChanged(this.basicSettings.getPlayingTime(), this.basicSettings.getAiPlayers(), this.basicSettings.isBonusItems(), this.basicSettings.isPublicGame(), this.basicSettings.isAllowJoiningDuringGame());
    }

    private void fireLevelSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.fireLevelSettingsChanged(listener);
        }
    }

    private void fireLevelSettingsChanged(Listener listener) {
        listener.levelsChanged(this.levels);
    }

    private void firePlayersSettingsChanged() {
        for (Listener listener : this.listeners) {
            this.firePlayersSettingsChanged(listener);
        }
    }

    private void firePlayersSettingsChanged(Listener listener) {
        listener.playersChanged(this.players);
    }

    public static interface Listener {
        public void basicSettingsChanged(int var1, int var2, boolean var3, boolean var4, boolean var5);

        public void levelsChanged(List<String> var1);

        public void playersChanged(List<PlayerInfo> var1);
    }
}

