/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.io.IOException;
import lonelycoders.ufohippa.client.gl.Composer;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.texturing.FBOTexture;
import lonelycoders.ufohippa.client.gl.texturing.RenderedTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.gl.BlurPass;
import lonelycoders.ufohippa.client.renderer.gl.FullScreenQuad;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.general.Logger;

public class BloomRenderer
extends Composer {
    public BloomRenderer(ResourceManager resourceManager, RenderPass mainPass) {
        super(new RenderPass[0]);
        try {
            Shader blendShader = resourceManager.addResource(new ResourceKey("Blend shader"), new ResourceCreator<Shader>(){

                @Override
                public Shader create() {
                    return new Shader("shaders/blend");
                }
            });
            Shader extractBrightsShader = resourceManager.addResource(new ResourceKey("Brights shader"), new ResourceCreator<Shader>(){

                @Override
                public Shader create() {
                    return new Shader("shaders/brights");
                }
            });
            RenderedTexture offscreen1 = resourceManager.getResourceLoader().enqueue(new FBOTexture(Texture.Type.TYPE_2D, 256));
            RenderedTexture offscreen2 = resourceManager.getResourceLoader().enqueue(new FBOTexture(Texture.Type.TYPE_2D, 256));
            RenderTarget offscreen1Target = new RenderTarget(offscreen1);
            RenderTarget offscreen2Target = new RenderTarget(offscreen2);
            this.addRenderPass(offscreen1Target, mainPass);
            this.addRenderPass(offscreen2Target, new FullScreenQuad(offscreen1, extractBrightsShader, false));
            BlurPass horizontalBlur = new BlurPass(resourceManager, offscreen2, BlurPass.Direction.HORIZONTAL, BlurPass.Distribution.GAUSSIAN, 3);
            BlurPass verticalBlur = new BlurPass(resourceManager, offscreen1, BlurPass.Direction.VERTICAL, BlurPass.Distribution.GAUSSIAN, 3);
            for (int i = 0; i < 1; ++i) {
                this.addRenderPass(offscreen1Target, horizontalBlur);
                this.addRenderPass(offscreen2Target, verticalBlur);
            }
            this.addRenderPass(RenderTarget.SCREEN_TARGET, mainPass);
            this.addRenderPass(RenderTarget.SCREEN_TARGET, new FullScreenQuad(offscreen2, blendShader, false));
        }
        catch (IOException e) {
            Logger.exception(e);
        }
    }
}

