/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;
import lonelycoders.ufohippa.client.gl.Camera;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.LookAtCamera;
import lonelycoders.ufohippa.client.gl.Material;
import lonelycoders.ufohippa.client.gl.PhongMaterial;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.gl.BackgroundEffect;
import lonelycoders.ufohippa.client.renderer.gl.StarFieldEffect;
import lonelycoders.ufohippa.client.renderer.gl.UfoModel;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.client.resource.TileResource;
import lonelycoders.ufohippa.client.resource.TileResourceManager;
import lonelycoders.ufohippa.game.Round;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.level.TileMap;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.ufo.Bullet;
import lonelycoders.ufohippa.game.ufo.TagState;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;

public class GameRenderer
extends RenderPass {
    private static final ColorRGB TELEPORT_NORMAL_COLOR = new ColorRGB(0.3f, 0.5f, 1.2f);
    private static final ColorRGB TELEPORT_ANYWHERE_COLOR = new ColorRGB(1.2f, 0.4f, 0.4f);
    private static final ResourceKey<Shader> SHADER_TELEPORT = new ResourceKey("Teleport shader");
    private final GLDrawable glPanel;
    private final ResourceManager resourceManager;
    private final TileResourceManager tileResourceManager;
    private final AnimationTimer animationTimer;
    private final GLU glu = new GLU();
    private final Shader phongShader;
    private final Material tileMaterial = new PhongMaterial(ColorRGB.WHITE, ColorRGB.WHITE, 50.0f);
    private final Material ufoMaterial = new PhongMaterial(ColorRGB.WHITE, ColorRGB.WHITE, 30.0f);
    private final UfoModel ufoModel;
    private final Texture flareTexture;
    private final Shader teleportShader;
    private final BackgroundEffect backgroundEffect;
    private Round round;
    private Camera camera;

    public GameRenderer(GLDrawable glPanel, ResourceManager resourceManager, AnimationTimer animationTimer) {
        this.glPanel = glPanel;
        this.resourceManager = resourceManager;
        this.animationTimer = animationTimer;
        GameResources.load(resourceManager);
        this.phongShader = resourceManager.getResource(GameResources.SHADER_PHONG_MULTILIGHT);
        this.ufoModel = new UfoModel(resourceManager);
        this.flareTexture = resourceManager.getResource(GeneralResources.TEXTURE_FLARE64);
        resourceManager.addResource(SHADER_TELEPORT, new Shader("shaders/teleport"));
        this.teleportShader = resourceManager.getResource(SHADER_TELEPORT);
        this.backgroundEffect = new StarFieldEffect(this.flareTexture, animationTimer);
        this.tileResourceManager = new TileResourceManager();
        this.setCamera(new ActionCamera());
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void loadTileSet(TileSet tileSet) {
        for (Tile tile : tileSet.getAllTiles()) {
            this.tileResourceManager.enqueueTile(this.resourceManager, tileSet, tile);
        }
    }

    public void loadRound(Round round) {
        this.round = round;
        Level level = round.getLevel();
        this.loadTiles(level);
        this.backgroundEffect.initialize(level.getWidth(), level.getHeight());
    }

    public void loadTiles(Level level) {
        this.loadTileSet(level.getTileSet());
    }

    @Override
    public void doRender(GL gl) throws GLException {
        this.setupRendering(gl);
        this.renderBackground(gl);
        gl.glEnable(2896);
        this.renderLevel(gl, this.round.getLevel());
        for (Ufo ufo : this.round.getUfos()) {
            this.renderUfo(gl, ufo);
        }
        for (Bullet bullet : new ArrayList<Bullet>(this.round.getBullets())) {
            if (!bullet.isAlive()) continue;
            this.renderBullet(gl, bullet);
        }
    }

    private void setupRendering(GL gl) throws GLException {
        gl.glClear(16640);
        gl.glEnable(2896);
        gl.glEnable(2929);
        gl.glEnable(16385);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(60.0, (double)this.glPanel.getWidth() / (double)this.glPanel.getHeight(), 0.1, 50.0);
        gl.glMatrixMode(5888);
        this.camera.apply(gl);
        this.setupLights(gl);
        UtilGL.applyColor(gl, ColorRGB.WHITE);
        UtilGL.checkErrors(gl);
    }

    private void setupLights(GL gl) {
        float[] lightPosition = new float[]{-1.0f, 2.0f, 3.0f, 0.0f};
        gl.glLightfv(16384, 4611, lightPosition, 0);
        this.setupUfoLights(gl);
    }

    private void setupUfoLights(GL gl) {
        Ufo tagUfo = this.round.getTagUfo();
        if (tagUfo != null) {
            Vector2 ufoPosition = tagUfo.getPosition();
            float[] lightPosition = new float[]{ufoPosition.x, ufoPosition.y, 0.5f, 1.0f};
            float tagBrightness = this.round.isSafeTag() ? 0.5f : this.ufoModel.getTagBlinkState(this.animationTimer);
            ColorRGB ufoColor = tagUfo.getSkin().getColor();
            float[] lightColor = new float[]{tagBrightness * ufoColor.getRed(), tagBrightness * ufoColor.getGreen(), tagBrightness * ufoColor.getBlue(), 1.0f};
            gl.glLightfv(16385, 4611, lightPosition, 0);
            gl.glLightfv(16385, 4609, lightColor, 0);
        } else {
            gl.glLightfv(16385, 4611, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, 0);
            gl.glLightfv(16385, 4609, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, 0);
        }
    }

    private void renderBackground(GL gl) {
        this.backgroundEffect.render(gl, this.round.getLevel().getWidth(), this.round.getLevel().getHeight());
    }

    private void renderLevel(GL gl, Level level) throws GLException {
        this.phongShader.bind(gl);
        this.tileMaterial.apply(gl);
        RenderOptimizer renderOptimizer = new RenderOptimizer(gl);
        for (TileMap.TileIteration tileIteration : level.getTiles().getAllTiles()) {
            int x = tileIteration.x;
            int y = tileIteration.y;
            Tile tile = tileIteration.tile;
            ColorRGB color = tileIteration.color;
            if (!tile.isVisible()) continue;
            Vector3 offset = new Vector3(x, y, 0.0f);
            TileResource tileResource = this.tileResourceManager.getTileResource(level.getTileSet(), tile);
            tileResource.render(renderOptimizer, offset, color);
        }
        renderOptimizer.flush();
        for (Teleport teleport : level.getTeleports()) {
            this.renderTeleport(gl, teleport);
        }
        this.phongShader.unbind(gl);
        UtilGL.checkErrors(gl);
    }

    private void renderTeleport(GL gl, Teleport teleport) {
        ColorRGB color;
        int x = teleport.getX();
        int y = teleport.getY();
        gl.glTranslated((double)x + 0.5, (double)y + 0.5, 0.01);
        this.teleportShader.bind(gl);
        this.teleportShader.applyUniform(gl, "uTimer", this.animationTimer.getTime());
        switch (teleport.getType()) {
            case NORMAL: {
                color = TELEPORT_NORMAL_COLOR;
                break;
            }
            case ANYWHERE: {
                color = TELEPORT_ANYWHERE_COLOR;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        UtilGL.applyColor(gl, color);
        UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
        gl.glDisable(2929);
        UtilGL.drawSquare(gl, 0.0f, 0.0f, 0.0f, 0.75f);
        gl.glEnable(2929);
        UtilGL.disableBlend(gl);
        this.teleportShader.unbind(gl);
        gl.glTranslated(-((double)x + 0.5), -((double)y + 0.5), 0.01);
    }

    private void renderUfo(GL gl, Ufo ufo) throws GLException {
        this.ufoMaterial.apply(gl);
        Vector2 position = ufo.getPosition();
        gl.glTranslatef(position.x, position.y, 0.5f);
        TagState tagState = ufo == this.round.getTagUfo() ? (this.round.isSafeTag() ? TagState.NEXT_TAG : TagState.TAG) : TagState.FREE;
        this.ufoModel.render(gl, ufo.getSkin(), tagState, this.animationTimer);
        Vector2 crosshair = ufo.getCrosshair();
        if (crosshair != null) {
            crosshair.scale(1.8f);
            UtilGL.applyColor(gl, ColorRGB.WHITE);
            UtilGL.enableBlend(gl, UtilGL.BlendMode.ADDITIVE);
            UtilGL.drawTexturedSquare(gl, this.flareTexture, crosshair.x, crosshair.y, 0.4f, 0.089999996f);
            UtilGL.disableBlend(gl);
        }
        gl.glTranslatef(-position.x, -position.y, -0.5f);
        UtilGL.checkErrors(gl);
    }

    private void renderBullet(GL gl, Bullet bullet) throws GLException {
        Vector2 position = bullet.getPosition();
        gl.glDepthMask(false);
        UtilGL.enableBlend(gl, UtilGL.BlendMode.ADDITIVE);
        UtilGL.applyColor(gl, ColorRGB.WHITE);
        UtilGL.drawTexturedSquare(gl, this.flareTexture, position.x, position.y, 0.5f, 0.17999999f);
        UtilGL.disableBlend(gl);
        gl.glDepthMask(true);
        UtilGL.checkErrors(gl);
    }

    public class ActionCamera
    extends LookAtCamera {
        private static final int FPS = 100;
        private static final double FRAME_LENGTH = 0.01;
        private Vector3 currentCameraPosition;
        private Vector3 currentCameraTarget;
        private long time;
        private double timeLeftOver;
        private Round lastRound;

        private void updateConstantRate(GL gl) {
            if (GameRenderer.this.round != this.lastRound) {
                this.currentCameraPosition = null;
            }
            this.lastRound = GameRenderer.this.round;
            Level level = GameRenderer.this.round.getLevel();
            Iterable<Ufo> ufos = GameRenderer.this.round.getUfos();
            int levelWidth = level.getWidth();
            float levelCenterX = (float)levelWidth / 2.0f;
            int levelHeight = level.getHeight();
            float levelCenterY = (float)levelHeight / 2.0f;
            Vector2 minimumPosition = new Vector2(Float.MAX_VALUE, Float.MAX_VALUE);
            Vector2 maximumPosition = new Vector2(-3.4028235E38f, -3.4028235E38f);
            for (Ufo ufo : ufos) {
                Vector2 ufoPosition = ufo.getPosition();
                Vector2 ufoVelocity = ufo.getVelocity();
                minimumPosition.x = Math.min(minimumPosition.x, ufoPosition.x);
                minimumPosition.y = Math.min(minimumPosition.y, ufoPosition.y);
                maximumPosition.x = Math.max(maximumPosition.x, ufoPosition.x);
                maximumPosition.y = Math.max(maximumPosition.y, ufoPosition.y);
                float SPEED_MULTIPLIER = 100.0f;
                minimumPosition.x = Math.min(minimumPosition.x, ufoPosition.x + ufoVelocity.x * 100.0f);
                minimumPosition.y = Math.min(minimumPosition.y, ufoPosition.y + ufoVelocity.x * 100.0f);
                maximumPosition.x = Math.max(maximumPosition.x, ufoPosition.x + ufoVelocity.x * 100.0f);
                maximumPosition.y = Math.max(maximumPosition.y, ufoPosition.y + ufoVelocity.x * 100.0f);
            }
            minimumPosition.x = Math.min(minimumPosition.x, (float)(levelWidth * 3 / 5));
            minimumPosition.y = Math.min(minimumPosition.y, (float)(levelHeight * 3 / 5));
            maximumPosition.x = Math.max(maximumPosition.x, (float)(levelWidth * 2 / 5));
            maximumPosition.y = Math.max(maximumPosition.y, (float)(levelHeight * 2 / 5));
            minimumPosition.x = Math.max(0.0f, minimumPosition.x);
            minimumPosition.y = Math.max(0.0f, minimumPosition.y);
            maximumPosition.x = Math.min((float)levelWidth, maximumPosition.x);
            maximumPosition.y = Math.min((float)levelHeight, maximumPosition.y);
            Vector2 center = new Vector2(maximumPosition);
            center.add(minimumPosition);
            center.scale(0.5f);
            Vector2 size = new Vector2(maximumPosition);
            size.sub(minimumPosition);
            int panelWidth = GameRenderer.this.glPanel.getWidth();
            int panelHeight = GameRenderer.this.glPanel.getHeight();
            Vector3 levelBounds = new Vector3((float)(levelWidth + 2) * 0.5f, (float)(levelHeight + 2) * 0.5f, 0.0f);
            float fullWidthZ = 1.0f;
            float fullHeightZ = 1.0f;
            gl.glPushMatrix();
            for (int i = 0; i < 5; ++i) {
                gl.glLoadIdentity();
                GameRenderer.this.glu.gluLookAt(0.0, 0.0, fullWidthZ, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                Vector3 screenPosition = UtilGL.getScreenPosition(gl, levelBounds, new Dimension(panelWidth, panelHeight));
                fullWidthZ = fullWidthZ * screenPosition.x / (float)panelWidth;
                gl.glLoadIdentity();
                GameRenderer.this.glu.gluLookAt(0.0, 0.0, fullHeightZ, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                screenPosition = UtilGL.getScreenPosition(gl, levelBounds, new Dimension(panelWidth, panelHeight));
                fullHeightZ = fullHeightZ * screenPosition.y / (float)panelHeight;
            }
            gl.glPopMatrix();
            size.scale(1.4f);
            size.x = Math.min((float)levelWidth, size.x);
            size.y = Math.min((float)levelHeight, size.y);
            float widthZ = fullWidthZ * Math.max(size.x / (float)levelWidth, 0.5f);
            float heightZ = fullHeightZ * Math.max(size.y / (float)levelHeight, 0.5f);
            float z = Math.max(widthZ, heightZ);
            float maxOffsetX = Math.max(0.0f, (float)(levelWidth + 2) * 0.5f * (1.0f - z / fullWidthZ));
            float maxOffsetY = Math.max(0.0f, (float)(levelHeight + 2) * 0.5f * (1.0f - z / fullHeightZ));
            center.x = Math.min(Math.max(center.x, levelCenterX - maxOffsetX), levelCenterX + maxOffsetX);
            center.y = Math.min(Math.max(center.y, levelCenterY - maxOffsetY), levelCenterY + maxOffsetY);
            Vector2 newCenter = new Vector2(center);
            Vector3 newCameraPosition = new Vector3(newCenter.x, newCenter.y, z);
            Vector3 newCameraTarget = new Vector3(newCenter.x, newCenter.y, 0.0f);
            if (this.currentCameraPosition == null) {
                this.currentCameraPosition = newCameraPosition;
                this.currentCameraTarget = newCameraTarget;
            } else {
                float speed = 0.01f;
                if (newCameraPosition.z > this.currentCameraPosition.z) {
                    speed *= 4.0f;
                }
                this.currentCameraPosition.blend(newCameraPosition, speed * 0.5f);
                this.currentCameraTarget.blend(newCameraTarget, speed);
            }
        }

        @Override
        public void apply(GL gl) {
            long currentTime = System.nanoTime();
            if (this.time == 0L) {
                this.time = currentTime;
            }
            double deltaTime = (double)(currentTime - this.time) / 1.0E9;
            this.time = currentTime;
            this.timeLeftOver += deltaTime;
            while (this.timeLeftOver >= 0.01) {
                this.timeLeftOver -= 0.01;
                this.updateConstantRate(gl);
            }
            if (this.currentCameraPosition == null) {
                this.updateConstantRate(gl);
            }
            super.apply(gl);
        }

        @Override
        protected Vector3 getEye() {
            return this.currentCameraPosition;
        }

        @Override
        protected Vector3 getCenter() {
            return this.currentCameraTarget;
        }
    }

    public class FullLevelCamera
    extends Camera {
        @Override
        public void apply(GL gl) {
            super.apply(gl);
            Level level = GameRenderer.this.round.getLevel();
            float centerX = (float)level.getWidth() / 2.0f;
            float centerY = (float)level.getHeight() / 2.0f;
            GameRenderer.this.glu.gluLookAt(centerX, centerY, 1.0, centerX, centerY, 0.0, 0.0, 1.0, 0.0);
            Vector3 screenPosition = UtilGL.getScreenPosition(gl, new Vector3(level.getWidth(), level.getHeight(), 0.0f), new Dimension(GameRenderer.this.glPanel.getWidth(), GameRenderer.this.glPanel.getHeight()));
            float hScale = 2.0f * screenPosition.x / (float)GameRenderer.this.glPanel.getWidth();
            float vScale = 2.0f * screenPosition.y / (float)GameRenderer.this.glPanel.getHeight();
            gl.glTranslatef(0.0f, 0.0f, -Math.max(hScale, vScale));
        }
    }

    private class BadCamera
    extends LookAtCamera {
        private BadCamera() {
        }

        @Override
        protected Vector3 getEye() {
            Level level = GameRenderer.this.round.getLevel();
            int levelWidth = level.getWidth();
            int levelHeight = level.getHeight();
            float xScale = (float)levelWidth / (float)GameRenderer.this.glPanel.getWidth();
            float yScale = (float)levelHeight / (float)GameRenderer.this.glPanel.getHeight();
            float centerX = (float)levelWidth / 2.0f;
            float centerY = (float)levelHeight / 2.0f;
            float aspect = (float)GameRenderer.this.glPanel.getWidth() / (float)GameRenderer.this.glPanel.getHeight();
            float distance = Math.max(xScale, yScale);
            return new Vector3(centerX, centerY, 30.0f / aspect);
        }

        @Override
        protected Vector3 getCenter() {
            Level level = GameRenderer.this.round.getLevel();
            float centerX = (float)level.getWidth() / 2.0f;
            float centerY = (float)level.getHeight() / 2.0f;
            Vector2 ufoCenter = new Vector2(0.0f, 0.0f);
            Vector2 ufoDistance = new Vector2(0.0f, 0.0f);
            int ufoCount = 0;
            for (Ufo ufo : GameRenderer.this.round.getUfos()) {
                ufoCenter.add(ufo.getPosition());
                ++ufoCount;
                for (Ufo ufo2 : GameRenderer.this.round.getUfos()) {
                    if (ufo == ufo2) break;
                    Vector2 distance = new Vector2(ufo.getPosition());
                    distance.sub(ufo2.getPosition());
                    ufoDistance.add(distance);
                }
            }
            for (int i = 0; i < 10; ++i) {
                ufoCenter.add(new Vector2(centerX, centerY));
                ++ufoCount;
            }
            ufoCenter.scale(1.0f / (float)ufoCount);
            ufoDistance.scale(1.0f / (float)((ufoCount - 1) * ufoCount));
            return new Vector3(ufoCenter.x, ufoCenter.y, 0.0f);
        }
    }
}

