/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import com.sun.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.Renderer;
import lonelycoders.ufohippa.client.renderer.gl.BloomRenderer;
import lonelycoders.ufohippa.client.renderer.gl.LoadingScreenRenderer;
import lonelycoders.ufohippa.client.renderer.gl.MatchRenderer;
import lonelycoders.ufohippa.client.renderer.gl.ResultsRenderer;
import lonelycoders.ufohippa.client.renderer.gl.WaitingScreenRenderer;
import lonelycoders.ufohippa.client.resource.DelayedResourceLoader;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.general.Logger;

public class OpenGLRenderer
implements Renderer,
GLEventListener {
    private final Object gameLock;
    private final ResourceManager resourceManager;
    private final JPanel panel;
    private final GLAutoDrawable glPanel;
    private Match match;
    private MatchRenderer matchRenderer;
    private RenderPass gameBloomRenderer;
    private ResultsRenderer resultsRenderer;
    private LoadingScreenRenderer loadingScreenRenderer;
    private WaitingScreenRenderer waitingScreenRenderer;
    private boolean active = false;
    private long time;
    private final AnimationTimer animationTimer;
    private Animator animator;

    public OpenGLRenderer(Object gameLock, ResourceManager resourceManager) {
        this.gameLock = gameLock;
        this.resourceManager = resourceManager;
        this.panel = new JPanel(new BorderLayout());
        GLCanvas glPanel = new GLCanvas();
        glPanel.setPreferredSize(new Dimension(800, 600));
        glPanel.addGLEventListener(this);
        this.glPanel = glPanel;
        this.panel.add((Component)glPanel, "Center");
        this.animationTimer = new AnimationTimer();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForActive() {
        OpenGLRenderer openGLRenderer = this;
        synchronized (openGLRenderer) {
            while (!this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.exception(e);
                }
            }
        }
    }

    @Override
    public void initialize(Match match) {
        this.match = match;
        this.matchRenderer.loadMatch(match);
        this.resultsRenderer.setMatch(match);
        this.time = System.nanoTime();
        this.animationTimer.reset();
    }

    @Override
    public void requestRender() {
    }

    @Override
    public void clear() {
        this.resourceManager.clear();
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GLAutoDrawable drawable) {
        GeneralResources.load(this.resourceManager);
        GL gl = drawable.getGL();
        float[] lightAmbient = new float[]{0.0f, 0.0f, 0.0f};
        float[] lightDiffuse = new float[]{0.8f, 0.8f, 0.8f};
        gl.glEnable(16384);
        gl.glLightfv(16384, 4608, lightAmbient, 0);
        gl.glLightfv(16384, 4609, lightDiffuse, 0);
        gl.glEnable(2903);
        gl.glColorMaterial(1032, 5634);
        gl.glEnable(2884);
        gl.glEnable(2977);
        gl.glLightModeli(2897, 1);
        float[] globalAmbient = new float[]{0.3f, 0.3f, 0.3f};
        gl.glLightModelfv(2899, globalAmbient, 0);
        gl.glHint(3152, 4354);
        this.animationTimer.reset();
        this.matchRenderer = new MatchRenderer(this.glPanel, this.resourceManager, this.animationTimer);
        this.gameBloomRenderer = new BloomRenderer(this.resourceManager, (RenderPass)this.matchRenderer);
        this.resultsRenderer = new ResultsRenderer(RenderTarget.SCREEN_TARGET, this.glPanel, this.resourceManager, this.animationTimer);
        this.loadingScreenRenderer = new LoadingScreenRenderer(RenderTarget.SCREEN_TARGET, this.glPanel, gl, this.animationTimer);
        this.waitingScreenRenderer = new WaitingScreenRenderer(RenderTarget.SCREEN_TARGET, this.glPanel, this.resourceManager, this.animationTimer);
        try {
            UtilGL.checkErrors(gl);
        }
        catch (GLException e) {
            e.printStackTrace();
        }
        if (this.animator != null) {
            this.animator.stop();
        }
        this.animator = new Animator(this.glPanel);
        this.animator.start();
        OpenGLRenderer openGLRenderer = this;
        synchronized (openGLRenderer) {
            this.active = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable drawable) {
        Object object = this.gameLock;
        synchronized (object) {
            long currentTime = System.nanoTime();
            long deltaTime = currentTime - this.time;
            this.time = currentTime;
            this.update((double)deltaTime / 1.0E9);
            try {
                this.render(drawable.getGL());
            }
            catch (GLException e) {
                e.printStackTrace();
            }
        }
    }

    private void update(double deltaTime) {
        this.animationTimer.update(deltaTime);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    @Override
    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    private void render(GL gl) throws GLException {
        DelayedResourceLoader resourceLoader = this.resourceManager.getResourceLoader();
        if (!resourceLoader.isFinished()) {
            resourceLoader.update(gl);
            this.loadingScreenRenderer.render(gl);
        } else if (this.match != null) {
            switch (this.match.getState()) {
                case NONE: {
                    break;
                }
                case LOADING: {
                    this.loadingScreenRenderer.render(gl);
                    break;
                }
                case WAITING: {
                    this.waitingScreenRenderer.render(gl);
                    break;
                }
                case ROUND: {
                    this.gameBloomRenderer.render(gl);
                    break;
                }
                case ROUND_RESULTS: 
                case MATCH_RESULTS: 
                case END_RESULTS: {
                    this.resultsRenderer.render(gl);
                }
            }
            UtilGL.checkErrors(gl);
        }
    }
}

