/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.MeshUtil;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.gl.UfoModel;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.RoundResults;
import lonelycoders.ufohippa.game.ufo.TagState;
import lonelycoders.ufohippa.game.ufo.UfoSkin;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class ResultsRenderer
extends RenderPass {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 48);
    private final TextRenderer titleFontRenderer = new TextRenderer(TITLE_FONT, true, true);
    private static final Font CONTINUE_FONT = new Font("SansSerif", 0, 16);
    private final TextRenderer continueFontRenderer = new TextRenderer(CONTINUE_FONT, true, true);
    private static final float SMALL_FONT_SIZE = 64.0f;
    private static final float[] SCALES = new float[]{1.6f, 1.4f, 1.2f, 1.0f};
    private static final Font SMALL_FONT = new Font("SansSerif", 1, 64);
    private final TextRenderer smallFontRenderer = new TextRenderer(SMALL_FONT, true, true);
    private static final Font SMALL_FONT_2 = new Font("Serif", 1, 64);
    private final TextRenderer smallFontRenderer2 = new TextRenderer(SMALL_FONT_2, true, true);
    private final GLDrawable glPanel;
    private final AnimationTimer animationTimer;
    private final Shader backgroundShader;
    private final Texture backgroundTexture;
    private final Texture plasmaTexture;
    private final UfoModel ufoModel;
    private final Shader phongShader;
    private final MeshGL[] cubes;
    private static final float[] CUBE_HEIGHTS = new float[]{0.9f, 0.6f, 0.4f};
    private Match match;
    private final GLU glu = new GLU();

    public ResultsRenderer(RenderTarget target, GLDrawable glPanel, ResourceManager resourceManager, AnimationTimer animationTimer) {
        super(target);
        this.glPanel = glPanel;
        this.animationTimer = animationTimer;
        this.backgroundShader = resourceManager.addResource(new ResourceKey("Results shader"), new ResourceCreator<Shader>(){

            @Override
            public Shader create() {
                return new Shader("shaders/results");
            }
        });
        this.backgroundTexture = resourceManager.getResource(GeneralResources.TEXTURE_CIRCLE32);
        this.plasmaTexture = resourceManager.addResource(new ResourceKey("Plasma texture"), new ResourceCreator<Texture>(){

            @Override
            public Texture create() {
                return new ImageTexture(new ImageTexture.ImageGenerator(){
                    private static final int SIZE = 256;

                    @Override
                    public int getWidth() {
                        return 256;
                    }

                    @Override
                    public int getHeight() {
                        return 256;
                    }

                    @Override
                    public ImageTexture.Format getFormat() {
                        return ImageTexture.Format.GRAYSCALE;
                    }

                    @Override
                    public Buffer getPixels() {
                        ByteBuffer pixels = BufferUtil.newByteBuffer(65536);
                        double radius = 127.5;
                        for (int y = 0; y < 256; ++y) {
                            for (int x = 0; x < 256; ++x) {
                                double x2 = ((double)x - radius) / radius / Math.sqrt(2.0);
                                double y2 = ((double)y - radius) / radius / Math.sqrt(2.0);
                                double alpha = Math.sqrt(x2 * x2 + y2 * y2);
                                alpha = Math.sin(alpha * 5.0) * 0.5 + 0.5;
                                pixels.put((byte)(alpha * 256.0));
                            }
                        }
                        pixels.flip();
                        return pixels;
                    }
                });
            }
        });
        this.ufoModel = new UfoModel(resourceManager);
        this.phongShader = resourceManager.getResource(GeneralResources.SHADER_PHONG);
        this.cubes = new MeshGL[]{this.createCube(resourceManager, CUBE_HEIGHTS[0]), this.createCube(resourceManager, CUBE_HEIGHTS[1]), this.createCube(resourceManager, CUBE_HEIGHTS[2])};
    }

    private MeshGL createCube(ResourceManager resourceManager, final float height) {
        return resourceManager.addResource(new ResourceKey("Results stand cube " + height), new ResourceCreator<MeshGL>(){

            @Override
            public MeshGL create() {
                return new MeshGL(MeshUtil.createRoundedCube(1.0f, height, 1.0f, 0.03f), MeshGL.RenderType.VERTEX_BUFFER);
            }
        });
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    @Override
    protected void doRender(GL gl) throws GLException {
        this.startFrame(gl);
        int width = this.glPanel.getWidth();
        int height = this.glPanel.getHeight();
        this.setup2D(gl);
        this.drawBackground(gl, width, height);
        this.setup3D(gl);
        this.drawResultsText(gl, width, height);
        this.endFrame();
    }

    private void startFrame(GL gl) throws GLException {
        gl.glClear(256);
        UtilGL.checkErrors(gl);
    }

    private void setup2D(GL gl) {
        gl.glDisable(2896);
        gl.glDisable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private void drawBackground(GL gl, int width, int height) {
        this.backgroundShader.bind(gl);
        this.backgroundShader.applyUniform(gl, "uTimer", this.animationTimer.getTime());
        this.backgroundShader.applyUniform(gl, "uColor1", new ColorRGB(0.3f, 0.3f, 0.3f));
        this.backgroundShader.applyUniform(gl, "uColor2", new ColorRGB(0.28f, 0.28f, 0.28f));
        this.backgroundTexture.bind(gl, this.backgroundShader, "uTexture");
        this.plasmaTexture.bind(gl, this.backgroundShader, "uPlasmaTexture", 1);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glMultiTexCoord2f(33985, 0.0f, 0.0f);
        gl.glVertex2f(-1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, 0.0f);
        gl.glMultiTexCoord2f(33985, 1.0f, 0.0f);
        gl.glVertex2f(1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, height / 32);
        gl.glMultiTexCoord2f(33985, 1.0f, 1.0f);
        gl.glVertex2f(1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, height / 32);
        gl.glMultiTexCoord2f(33985, 0.0f, 1.0f);
        gl.glVertex2f(-1.0f, 1.0f);
        gl.glEnd();
        this.plasmaTexture.unbind(gl, 1);
        this.backgroundTexture.unbind(gl);
        this.backgroundShader.unbind(gl);
    }

    private void setup3D(GL gl) throws GLException {
        gl.glEnable(2896);
        gl.glEnable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(60.0, (double)this.glPanel.getWidth() / (double)this.glPanel.getHeight(), 0.1, 50.0);
        this.setupCamera(gl);
        this.setupLights(gl);
        UtilGL.checkErrors(gl);
    }

    private void drawResultsText(GL gl, int width, int height) throws GLException {
        float masterScale = 1.0f;
        int playerCount = this.match.getPlayers().size();
        if (playerCount > 11) {
            masterScale = 11.0f / (float)playerCount;
        }
        masterScale *= 0.9f;
        switch (this.match.getState()) {
            case ROUND_RESULTS: {
                this.renderTitleText(width, height, "Round #" + (this.match.getCurrentRoundNumber() + 1) + " results");
                gl.glPushMatrix();
                gl.glTranslatef(-12.0f, 5.0f, 0.0f);
                RoundResults roundResults = this.match.getRoundResults();
                List<String[]> order = roundResults.getCurrentRoundPlayersOrder();
                int rank = 0;
                for (String[] playerNames : order) {
                    int scaleIndex = Math.min((rank += playerNames.length) - 1, 3);
                    float scale = SCALES[scaleIndex] * masterScale;
                    float lineHeight = 1.5f * scale;
                    for (String playerName : playerNames) {
                        int newPlayerPoints = roundResults.getAddedPlayerPoints().get(playerName);
                        double tagTime = roundResults.getPlayerTagTimes().get(playerName);
                        int seconds = (int)tagTime;
                        int hundreths = (int)((tagTime - (double)seconds) * 100.0);
                        int minutes = seconds / 60;
                        String time = String.format("%d:%02d.%03d", minutes, seconds %= 60, hundreths);
                        this.renderPlayerStatus(gl, scale, rank, playerName, newPlayerPoints + " points (" + time + ")");
                        gl.glTranslatef(0.0f, -lineHeight, 0.0f);
                    }
                }
                this.renderContinueText(width, height);
                gl.glPopMatrix();
                break;
            }
            case MATCH_RESULTS: {
                this.renderTitleText(width, height, "Results after round #" + (this.match.getCurrentRoundNumber() + 1) + " of " + this.match.getLevels().length);
                gl.glPushMatrix();
                gl.glTranslatef(-12.0f, 5.0f, 0.0f);
                RoundResults roundResults = this.match.getRoundResults();
                List<String[]> order = roundResults.getAllRoundsNewPlayersOrder();
                int rank = 0;
                for (String[] playerNames : order) {
                    int scaleIndex = Math.min((rank += playerNames.length) - 1, 3);
                    float scale = SCALES[scaleIndex] * masterScale;
                    float lineHeight = 1.5f * scale;
                    for (String playerName : playerNames) {
                        int oldPlayerPoints = roundResults.getOldPlayerPoints().get(playerName);
                        int newPlayerPoints = roundResults.getAddedPlayerPoints().get(playerName);
                        this.renderPlayerStatus(gl, scale, rank, playerName, oldPlayerPoints + newPlayerPoints + " points");
                        gl.glTranslatef(0.0f, -lineHeight, 0.0f);
                    }
                }
                this.renderContinueText(width, height);
                gl.glPopMatrix();
                break;
            }
            case END_RESULTS: {
                int i;
                gl.glPushMatrix();
                gl.glLoadIdentity();
                this.glu.gluLookAt(0.8f, 1.0, 4.0, 0.0, -0.6f, 0.0, 0.0, 1.0, 0.0);
                RoundResults roundResults = this.match.getRoundResults();
                List<String[]> order = roundResults.getAllRoundsNewPlayersOrder();
                String[][] winners = new String[3][0];
                int rank = -1;
                for (String[] players : order) {
                    if ((rank += players.length) >= 3) continue;
                    winners[rank] = players;
                }
                this.phongShader.bind(gl);
                UtilGL.applyColor(gl, ColorRGB.LIGHT_GRAY);
                gl.glTranslatef(-0.5f, 0.0f, 0.0f);
                int[] ranks = new int[3];
                if (winners[0].length == 1) {
                    ranks[0] = 0;
                    if (winners[1].length == 1) {
                        ranks[1] = 1;
                        ranks[2] = winners[2].length == 1 ? 2 : -1;
                    } else if (winners[2].length == 2) {
                        ranks[1] = 2;
                        ranks[2] = 2;
                    } else {
                        ranks[1] = -1;
                        ranks[2] = -1;
                    }
                } else if (winners[1].length == 2) {
                    ranks[0] = 1;
                    ranks[1] = 1;
                    ranks[2] = winners[2].length == 1 ? 2 : -1;
                } else if (winners[2].length == 3) {
                    ranks[0] = 2;
                    ranks[1] = 2;
                    ranks[2] = 2;
                } else {
                    ranks[0] = -1;
                    ranks[1] = -1;
                    ranks[2] = -1;
                }
                int[] offsets = new int[]{0, -1, 1};
                for (i = 0; i < 3; ++i) {
                    if (ranks[i] == -1) continue;
                    gl.glTranslatef(offsets[i], 0.0f, 0.0f);
                    this.cubes[ranks[i]].render(gl);
                    gl.glTranslatef(-offsets[i], 0.0f, 0.0f);
                }
                for (i = 0; i < 3; ++i) {
                    if (ranks[i] != -1) continue;
                    gl.glTranslatef(offsets[i], 0.0f, 0.0f);
                    this.cubes[i].render(gl);
                    gl.glTranslatef(-offsets[i], 0.0f, 0.0f);
                }
                this.phongShader.unbind(gl);
                String[] rankTexts = new String[]{"I", "II", "III"};
                Color[] rankColors = new Color[]{new Color(240, 217, 25), new Color(230, 232, 250), new Color(166, 125, 61)};
                int index = 0;
                for (int j = 0; j < 3; ++j) {
                    gl.glPushMatrix();
                    int count = winners[j].length;
                    if (count > 0) {
                        for (int i2 = 0; i2 < count; ++i2) {
                            gl.glPushMatrix();
                            int rank2 = ranks[index];
                            if (rank2 != -1) {
                                gl.glTranslatef(offsets[index], CUBE_HEIGHTS[rank2], 0.0f);
                                gl.glTranslatef(0.5f, 0.3f, 0.5f);
                                gl.glScalef(0.4f, 0.4f, 0.4f);
                                String playerName = winners[j][i2];
                                gl.glTranslatef(0.0f, (float)Math.sin(this.animationTimer.getTime()) * 0.2f, 0.0f);
                                if (this.match.getPlayers().containsKey(playerName)) {
                                    UfoSkin skin = this.match.getPlayers().get(playerName).getSkin();
                                    this.ufoModel.render(gl, skin, TagState.FREE, this.animationTimer);
                                }
                                gl.glPopMatrix();
                                gl.glPushMatrix();
                                gl.glTranslatef(offsets[index], 0.0f, 1.02f);
                                float fontScale = 0.002f;
                                this.smallFontRenderer.begin3DRendering();
                                Rectangle2D bounds1 = this.smallFontRenderer.getBounds(playerName);
                                this.smallFontRenderer.draw3D(playerName, 0.5f - (float)bounds1.getWidth() * fontScale * 0.5f, 0.1f, 0.0f, fontScale);
                                this.smallFontRenderer.end3DRendering();
                                this.smallFontRenderer2.begin3DRendering();
                                this.smallFontRenderer2.setColor(rankColors[rank2]);
                                float statusScale = 1.0f + (float)(2 - rank2) * 0.5f;
                                float fontScale2 = fontScale * statusScale;
                                Rectangle2D bounds2 = this.smallFontRenderer2.getBounds(rankTexts[rank2]);
                                this.smallFontRenderer2.draw3D(rankTexts[rank2], 0.5f - (float)bounds2.getWidth() * fontScale2 * 0.5f, CUBE_HEIGHTS[rank2] - 0.15f * statusScale, 0.0f, fontScale2);
                                this.smallFontRenderer2.end3DRendering();
                                --playerCount;
                                gl.glPopMatrix();
                            }
                            ++index;
                        }
                    }
                    gl.glPopMatrix();
                }
                for (int i3 = 0; i3 < 3; ++i3) {
                    if (ranks[i3] != -1) continue;
                    gl.glPushMatrix();
                    gl.glTranslatef(offsets[i3], 0.0f, 1.02f);
                    float fontScale = 0.002f;
                    this.smallFontRenderer2.begin3DRendering();
                    this.smallFontRenderer2.setColor(rankColors[i3]);
                    float statusScale = 1.0f + (float)(2 - i3) * 0.5f;
                    float fontScale2 = fontScale * statusScale;
                    Rectangle2D bounds2 = this.smallFontRenderer2.getBounds(rankTexts[i3]);
                    this.smallFontRenderer2.draw3D(rankTexts[i3], 0.5f - (float)bounds2.getWidth() * fontScale2 * 0.5f, CUBE_HEIGHTS[i3] - 0.15f * statusScale, 0.0f, fontScale2);
                    this.smallFontRenderer2.end3DRendering();
                    gl.glPopMatrix();
                }
                gl.glPopMatrix();
                gl.glTranslatef(-12.0f, -1.0f, 0.0f);
                float masterScale2 = 1.0f;
                if (playerCount > 7) {
                    masterScale2 = 7.0f / (float)playerCount;
                }
                masterScale2 *= 0.9f;
                int rank3 = 0;
                for (String[] playerNames : order) {
                    if ((rank3 += playerNames.length) <= 3) continue;
                    int scaleIndex = Math.min(rank3 - 1, 3);
                    float scale = SCALES[scaleIndex] * masterScale2;
                    float lineHeight = 1.5f * scale;
                    for (String playerName : playerNames) {
                        this.renderPlayerStatus(gl, scale, rank3, playerName, "");
                        gl.glTranslatef(0.0f, -lineHeight, 0.0f);
                    }
                }
                this.renderContinueText(width, height);
                break;
            }
        }
    }

    private void renderTitleText(int width, int height, String titleText) {
        Rectangle2D textBounds = this.titleFontRenderer.getBounds(titleText);
        this.titleFontRenderer.beginRendering(width, height);
        this.titleFontRenderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.titleFontRenderer.draw(titleText, (int)((double)width - textBounds.getWidth()) / 2, height - 50 - (int)textBounds.getHeight());
        this.titleFontRenderer.endRendering();
    }

    private void renderContinueText(int width, int height) {
        String text = "Press enter to continue";
        Rectangle2D textBounds = this.continueFontRenderer.getBounds(text);
        this.continueFontRenderer.beginRendering(width, height);
        this.continueFontRenderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.continueFontRenderer.draw(text, (int)((double)width - textBounds.getWidth()) / 2, 10);
        this.continueFontRenderer.endRendering();
    }

    private void renderPlayerStatus(GL gl, float scale, int rank, String playerName, String text) {
        TextRenderer textRenderer = this.smallFontRenderer;
        float textScale = 0.015f * scale;
        textRenderer.begin3DRendering();
        UtilGL.applyColor(gl, ColorRGB.WHITE);
        String rankText = "" + rank + ".";
        Rectangle2D bounds = textRenderer.getBounds(rankText);
        textRenderer.draw3D(rankText, (float)(0.0 - bounds.getWidth() * (double)textScale), -0.5f * scale, 0.0f, textScale);
        textRenderer.draw3D(playerName.substring(0, Math.min(playerName.length(), 20)), 4.0f, -0.5f * scale, 0.0f, textScale);
        textRenderer.draw3D(text, 15.0f, -0.5f * scale, 0.0f, textScale);
        textRenderer.end3DRendering();
        gl.glPushMatrix();
        gl.glTranslatef(2.0f, 0.0f, 0.0f);
        gl.glScalef(scale, scale, scale);
        if (this.match.getPlayers().containsKey(playerName)) {
            UfoSkin skin = this.match.getPlayers().get(playerName).getSkin();
            this.ufoModel.render(gl, skin, TagState.FREE, this.animationTimer);
        }
        gl.glPopMatrix();
    }

    private void setupCamera(GL gl) {
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.glu.gluLookAt(0.0, 0.0, 20.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    private void setupLights(GL gl) {
        float[] lightPosition = new float[]{-1.0f, 2.0f, 3.0f, 0.0f};
        gl.glLightfv(16384, 4611, lightPosition, 0);
    }

    private void endFrame() {
    }
}

