/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.util.ArrayList;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.Mesh;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.Quad;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.Vertex;
import lonelycoders.ufohippa.client.gl.texturing.FlareTexture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.resource.DelayedResourceLoader;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.ufo.TagState;
import lonelycoders.ufohippa.game.ufo.UfoSkin;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.ColorRGBA;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;

public class UfoModel {
    private final MeshGL hullMesh;
    private final MeshGL interiorMesh;
    private final MeshGL domeMesh;
    private static final ColorRGBA domeColor = new ColorRGBA(0.5f, 0.75f, 1.0f, 0.5f);
    private static final float width = 1.8f;
    private static final float height = 0.9f;
    private static final float domeSize = 0.15f;
    private static final float domeR = (float)Math.sin(2.6703538304527297) * 1.8f / 2.0f;
    private static final float hullHeight = 0.9f - domeR;
    private static final float domeY = (float)(-Math.cos(2.6703538304527297)) * hullHeight / 2.0f;
    private static final float flareCount = 8.0f;
    private static final float flareRotationSpeed = 0.25f;
    private final Shader phongShader;
    private final FlareTexture flareTexture;

    public UfoModel(ResourceManager resourceManager) {
        this.phongShader = resourceManager.getResource(GeneralResources.SHADER_PHONG);
        int hullStacks = 10;
        int domeStacks = 5;
        int slices = 20;
        DelayedResourceLoader resourceLoader = resourceManager.getResourceLoader();
        this.hullMesh = resourceLoader.enqueue(new MeshGL(UfoModel.createHull(hullStacks, slices), MeshGL.RenderType.VERTEX_BUFFER));
        this.domeMesh = resourceLoader.enqueue(new MeshGL(UfoModel.createDome(domeStacks, slices), MeshGL.RenderType.VERTEX_BUFFER));
        this.interiorMesh = resourceLoader.enqueue(new MeshGL(UfoModel.createInterior(domeStacks, slices), MeshGL.RenderType.VERTEX_BUFFER));
        this.flareTexture = (FlareTexture)resourceManager.getResource(GeneralResources.TEXTURE_FLARE64);
    }

    private static Mesh createHull(int stacks, int slices) {
        int x;
        int y;
        ArrayList<Quad> quads = new ArrayList<Quad>();
        Vertex[] vertices = new Vertex[stacks * slices + 1];
        vertices[0] = new Vertex(new Vector3(0.0f, -hullHeight / 2.0f - domeR / 2.0f, 0.0f), new Vector2(0.0f, 0.0f), new Vector3(0.0f, -1.0f, 0.0f));
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                float r = (float)Math.sin(Math.PI * (double)y / (double)(stacks - 1) * (double)0.85f) * 1.8f / 2.0f;
                float vx = (float)Math.sin(Math.PI * 2 * (double)x / (double)slices) * r;
                float vy = (float)(-Math.cos(Math.PI * (double)y / (double)(stacks - 1) * (double)0.85f)) * hullHeight / 2.0f;
                float vz = (float)Math.cos(Math.PI * 2 * (double)x / (double)slices) * r / 2.0f;
                float tx = 0.0f;
                float ty = 0.0f;
                float nx = vx;
                float ny = vy * 1.8f / hullHeight;
                float nz = vz;
                vertices[1 + y * slices + x] = new Vertex(new Vector3(vx, vy - domeR / 2.0f, vz), new Vector2(tx, ty), new Vector3(nx, ny, nz, true));
            }
        }
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                int v1 = 1 + (y - 1) * slices + x;
                int v2 = 1 + (y - 1) * slices + (x + 1) % slices;
                int v3 = 1 + y * slices + (x + 1) % slices;
                int v4 = 1 + y * slices + x;
                v1 = v1 < 0 ? 0 : v1;
                v2 = v2 < 0 ? 0 : v2;
                quads.add(new Quad(vertices[v1], vertices[v2], vertices[v3], vertices[v4]));
            }
        }
        return new Mesh(quads.toArray(new Quad[quads.size()]));
    }

    private static Mesh createDome(int stacks, int slices) {
        int x;
        int y;
        ArrayList<Quad> quads = new ArrayList<Quad>();
        Vertex[] vertices = new Vertex[stacks * slices + 1];
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                float r = (float)Math.cos(Math.PI * (double)y / (double)stacks / 2.0) * domeR;
                float vx = (float)Math.sin(Math.PI * 2 * (double)x / (double)slices) * r;
                float vy = (float)Math.sin(Math.PI * (double)y / (double)stacks / 2.0) * domeR;
                float vz = (float)Math.cos(Math.PI * 2 * (double)x / (double)slices) * r / 2.0f;
                float tx = 0.0f;
                float ty = 0.0f;
                float nx = vx;
                float ny = vy;
                float nz = vz;
                vertices[y * slices + x] = new Vertex(new Vector3(vx, domeY + vy - domeR / 2.0f, vz), new Vector2(tx, ty), new Vector3(nx, ny, nz, true));
            }
        }
        vertices[stacks * slices] = new Vertex(new Vector3(0.0f, domeY + domeR - domeR / 2.0f, 0.0f), new Vector2(0.0f, 0.0f), new Vector3(0.0f, 1.0f, 0.0f));
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                int v1 = y * slices + x;
                int v2 = y * slices + (x + 1) % slices;
                int v3 = (y + 1) * slices + (x + 1) % slices;
                int v4 = (y + 1) * slices + x;
                v3 = v3 > stacks * slices ? stacks * slices : v3;
                v4 = v4 > stacks * slices ? stacks * slices : v4;
                quads.add(new Quad(vertices[v1], vertices[v2], vertices[v3], vertices[v4]));
            }
        }
        return new Mesh(quads.toArray(new Quad[quads.size()]));
    }

    private static Mesh createInterior(int stacks, int slices) {
        int x;
        int y;
        ArrayList<Quad> quads = new ArrayList<Quad>();
        Vertex[] vertices = new Vertex[stacks * slices + 1];
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                float r = (float)Math.cos(Math.PI * (double)y / (double)stacks / 2.0) * domeR;
                float vx = (float)Math.sin(Math.PI * 2 * (double)x / (double)slices) * r;
                float vy = (float)(-Math.sin(Math.PI * (double)y / (double)stacks / 2.0)) * domeR;
                float vz = (float)Math.cos(Math.PI * 2 * (double)x / (double)slices) * r / 2.0f;
                float tx = 0.0f;
                float ty = 0.0f;
                float nx = -vx;
                float ny = -vy;
                float nz = -vz;
                vertices[y * slices + x] = new Vertex(new Vector3(vx, domeY + vy - domeR / 2.0f, vz), new Vector2(tx, ty), new Vector3(nx, ny, nz, true));
            }
        }
        vertices[stacks * slices] = new Vertex(new Vector3(0.0f, domeY - domeR - domeR / 2.0f, 0.0f), new Vector2(0.0f, 0.0f), new Vector3(0.0f, 1.0f, 0.0f));
        for (y = 0; y < stacks; ++y) {
            for (x = 0; x < slices; ++x) {
                int v1 = y * slices + x;
                int v2 = y * slices + (x + 1) % slices;
                int v3 = (y + 1) * slices + (x + 1) % slices;
                int v4 = (y + 1) * slices + x;
                v3 = v3 > stacks * slices ? stacks * slices : v3;
                v4 = v4 > stacks * slices ? stacks * slices : v4;
                quads.add(new Quad(vertices[v1], vertices[v2], vertices[v3], vertices[v4]));
            }
        }
        return new Mesh(quads.toArray(new Quad[quads.size()]));
    }

    public void render(GL gl, UfoSkin skin, TagState tagState, AnimationTimer animationTimer) {
        ColorRGB color = skin.getColor().blend(0.5f);
        UtilGL.applyColor(gl, color);
        this.phongShader.bind(gl);
        this.hullMesh.render(gl);
        this.interiorMesh.render(gl);
        UtilGL.applyColorWithAlpha(gl, domeColor);
        UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
        gl.glCullFace(1028);
        this.domeMesh.render(gl);
        gl.glCullFace(1029);
        this.domeMesh.render(gl);
        UtilGL.disableBlend(gl);
        this.phongShader.unbind(gl);
        if (tagState != TagState.FREE) {
            gl.glColor3f(1.0f, 1.0f, 1.0f);
            UtilGL.enableBlend(gl, UtilGL.BlendMode.ADDITIVE);
            float timer = (float)animationTimer.getTime();
            float size = tagState == TagState.TAG ? this.getTagBlinkState(animationTimer) * 1.8f / 10.0f : 0.089999996f;
            int i = 0;
            while ((float)i < 8.0f) {
                float offset = (float)(Math.PI * 2 * (double)timer * 0.25);
                float x = (float)(Math.sin(Math.PI * 2 * (double)i / 8.0 + (double)offset) * (double)1.8f / 2.0);
                float y = -domeR / 2.0f;
                float z = (float)(Math.cos(Math.PI * 2 * (double)i / 8.0 + (double)offset) * (double)1.8f / 4.0);
                UtilGL.drawTexturedSquare(gl, this.flareTexture, x, y, z + 0.1f, size);
                ++i;
            }
            UtilGL.disableBlend(gl);
        }
    }

    public float getTagBlinkState(AnimationTimer animationTimer) {
        float state = (float)Math.sin(animationTimer.getTime() * 5.2);
        return state * state + 0.1f;
    }
}

