/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl.tiles.pipes;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.Mesh;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.MeshUtil;
import lonelycoders.ufohippa.client.gl.Quad;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.Triangle;
import lonelycoders.ufohippa.client.gl.Vertex;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.gl.Renderable;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;

public class Pipe
implements Renderable {
    private static final int DETAIL = 8;
    private static final Vector2 TEXTURE_COORDINATES = new Vector2(0.0f, 0.0f);
    private final MeshGL mesh;
    private final Shader phongShader;
    private final Texture texture;
    private final int rotation;

    public Pipe(ResourceManager resourceManager, final Shape shape) {
        this.phongShader = resourceManager.getResource(GameResources.SHADER_PHONG_MULTILIGHT);
        this.texture = resourceManager.getResource(GameResources.WHITE_TEXTURE);
        this.mesh = resourceManager.addResource(new ResourceKey("Tile pipe " + shape.baseShape.name()), new ResourceCreator<MeshGL>(){

            @Override
            public MeshGL create() {
                return new MeshGL(Pipe.this.createPipe(shape), MeshGL.RenderType.VERTEX_BUFFER);
            }
        });
        this.rotation = shape.rotation;
    }

    private Mesh createPipe(Shape shape) {
        switch (shape.baseShape) {
            case END: {
                return this.createEndPipe();
            }
            case STRAIGHT: {
                return this.createStraightPipe();
            }
            case CURVE: {
                return this.createCurvePipe();
            }
            case JUNCTION: {
                return this.createJunctionPipe();
            }
            case FULL: {
                return this.createFullPipe();
            }
            case NONE: {
                return this.createSpherePipe();
            }
        }
        throw new IllegalArgumentException();
    }

    private Mesh createEndPipe() {
        Vertex[] vertices = new Vertex[16];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 8.0;
            float y = (float)Math.sin(angle) * 0.5f;
            float z = (float)Math.cos(angle) * 0.5f;
            float ny = (float)Math.sin(angle);
            float nz = (float)Math.cos(angle);
            Vertex vertex1 = new Vertex(new Vector3(-0.5f, y, z), TEXTURE_COORDINATES, new Vector3(0.0f, ny, nz));
            Vertex vertex2 = new Vertex(new Vector3(0.0f, y, z), TEXTURE_COORDINATES, new Vector3(0.0f, ny, nz));
            vertices[vertexIndex++] = vertex1;
            vertices[vertexIndex++] = vertex2;
        }
        Quad[] quads = new Quad[8];
        int quadIndex = 0;
        for (int i = 0; i < 8; ++i) {
            Vertex v1 = vertices[i * 2 % vertices.length];
            Vertex v2 = vertices[(i * 2 + 1) % vertices.length];
            Vertex v3 = vertices[(i * 2 + 3) % vertices.length];
            Vertex v4 = vertices[(i * 2 + 2) % vertices.length];
            quads[quadIndex++] = new Quad(v1, v2, v3, v4);
        }
        Vertex[] vertices2 = new Vertex[64];
        int vertexIndex2 = 0;
        for (int i = 0; i < 8; ++i) {
            double angle1 = (double)i * Math.PI * 0.5 / 7.0;
            float x = (float)Math.sin(angle1) * 0.5f;
            float nx = (float)Math.sin(angle1);
            for (int j = 0; j < 8; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float y = (float)Math.cos(angle1) * (float)Math.sin(angle2) * 0.5f;
                float z = (float)Math.cos(angle1) * (float)Math.cos(angle2) * 0.5f;
                float ny = (float)Math.cos(angle1) * (float)Math.sin(angle2);
                float nz = (float)Math.cos(angle1) * (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices2[vertexIndex2++] = vertex;
            }
        }
        Quad[] quads2 = new Quad[56];
        int quadIndex2 = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                Vertex v1 = vertices2[i * 8 + j];
                Vertex v2 = vertices2[(i + 1) * 8 + j];
                Vertex v3 = vertices2[(i + 1) * 8 + (j + 1) % 8];
                Vertex v4 = vertices2[i * 8 + (j + 1) % 8];
                quads2[quadIndex2++] = new Quad(v1, v2, v3, v4);
            }
        }
        Triangle[] alltTriangles = MeshUtil.merge(MeshUtil.splitQuads(quads), MeshUtil.splitQuads(quads2));
        return new Mesh(alltTriangles);
    }

    private Mesh createStraightPipe() {
        Vertex[] vertices = new Vertex[16];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 8.0;
            float y = (float)Math.sin(angle) * 0.5f;
            float z = (float)Math.cos(angle) * 0.5f;
            float ny = (float)Math.sin(angle);
            float nz = (float)Math.cos(angle);
            Vertex vertex1 = new Vertex(new Vector3(-0.5f, y, z), TEXTURE_COORDINATES, new Vector3(0.0f, ny, nz));
            Vertex vertex2 = new Vertex(new Vector3(0.5f, y, z), TEXTURE_COORDINATES, new Vector3(0.0f, ny, nz));
            vertices[vertexIndex++] = vertex1;
            vertices[vertexIndex++] = vertex2;
        }
        Quad[] quads = new Quad[8];
        int quadIndex = 0;
        for (int i = 0; i < 8; ++i) {
            Vertex v1 = vertices[i * 2 % vertices.length];
            Vertex v2 = vertices[(i * 2 + 1) % vertices.length];
            Vertex v3 = vertices[(i * 2 + 3) % vertices.length];
            Vertex v4 = vertices[(i * 2 + 2) % vertices.length];
            quads[quadIndex++] = new Quad(v1, v2, v3, v4);
        }
        return new Mesh(quads);
    }

    private Mesh createCurvePipe() {
        Vertex[] vertices = new Vertex[64];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle1 = (double)i * Math.PI * 0.5 / 7.0;
            float x1 = (float)(Math.sin(angle1) * 0.5 - 0.5);
            float y1 = (float)(0.5 - Math.cos(angle1) * 0.5);
            for (int j = 0; j < 8; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float x = x1 + -((float)Math.sin(angle2)) * 0.5f * (float)Math.sin(angle1);
                float y = y1 + (float)Math.sin(angle2) * 0.5f * (float)Math.cos(angle1);
                float z = (float)Math.cos(angle2) * 0.5f;
                float nx = -((float)Math.sin(angle2)) * (float)Math.sin(angle1);
                float ny = (float)Math.sin(angle2) * (float)Math.cos(angle1);
                float nz = (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices[vertexIndex++] = vertex;
            }
        }
        Quad[] quads = new Quad[56];
        int quadIndex = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                Vertex v1 = vertices[i * 8 + j];
                Vertex v2 = vertices[(i + 1) * 8 + j];
                Vertex v3 = vertices[(i + 1) * 8 + (j + 1) % 8];
                Vertex v4 = vertices[i * 8 + (j + 1) % 8];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        return new Mesh(quads);
    }

    private Mesh createJunctionPipe() {
        int i;
        int i2;
        Vertex[] vertices = new Vertex[80];
        int vertexIndex = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            double angle1 = (double)i2 * Math.PI * 0.5 / 7.0;
            float x1 = (float)(Math.sin(angle1) * 0.5 - 0.5);
            float y1 = (float)(0.5 - Math.cos(angle1) * 0.5);
            for (int j = 0; j <= 4; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float x = x1 + -((float)Math.sin(angle2)) * 0.5f * (float)Math.sin(angle1);
                float y = y1 + (float)Math.sin(angle2) * 0.5f * (float)Math.cos(angle1);
                float z = (float)Math.cos(angle2) * 0.5f;
                float nx = -((float)Math.sin(angle2)) * (float)Math.sin(angle1);
                float ny = (float)Math.sin(angle2) * (float)Math.cos(angle1);
                float nz = (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices[vertexIndex++] = vertex;
            }
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (int j = 4; j <= 8; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float x = -0.5f + 0.5f * (float)i2 / 7.0f;
                float y = (float)Math.sin(angle2) * 0.5f;
                float z = (float)Math.cos(angle2) * 0.5f;
                float nx = 0.0f;
                float ny = (float)Math.sin(angle2);
                float nz = (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices[vertexIndex++] = vertex;
            }
        }
        Quad[] quads = new Quad[56];
        int quadIndex = 0;
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vertex v1 = vertices[i * 5 + j];
                Vertex v2 = vertices[(i + 1) * 5 + j];
                Vertex v3 = vertices[(i + 1) * 5 + (j + 1)];
                Vertex v4 = vertices[i * 5 + (j + 1)];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                int offset = 40;
                Vertex v1 = vertices[offset + i * 5 + j];
                Vertex v2 = vertices[offset + (i + 1) * 5 + j];
                Vertex v3 = vertices[offset + (i + 1) * 5 + (j + 1)];
                Vertex v4 = vertices[offset + i * 5 + (j + 1)];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        Triangle[] fillTriangles = new Triangle[7];
        Vertex v1 = new Vertex(new Vector3(0.0f, 0.0f, 0.5f), TEXTURE_COORDINATES, new Vector3(0.0f, 0.0f, 1.0f));
        for (int i3 = 0; i3 < 7; ++i3) {
            Vertex v2 = vertices[(i3 + 1) * 5];
            Vertex v3 = vertices[i3 * 5];
            fillTriangles[i3] = new Triangle(v1, v2, v3);
        }
        Triangle[] allTriangles = MeshUtil.merge(MeshUtil.splitQuads(quads), fillTriangles);
        allTriangles = MeshUtil.mirrorHorizontal(allTriangles);
        return new Mesh(allTriangles);
    }

    private Mesh createFullPipe() {
        Vertex[] vertices = new Vertex[40];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle1 = (double)i * Math.PI * 0.5 / 7.0;
            float x1 = (float)(Math.sin(angle1) * 0.5 - 0.5);
            float y1 = (float)(0.5 - Math.cos(angle1) * 0.5);
            for (int j = 0; j <= 4; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float x = x1 + -((float)Math.sin(angle2)) * 0.5f * (float)Math.sin(angle1);
                float y = y1 + (float)Math.sin(angle2) * 0.5f * (float)Math.cos(angle1);
                float z = (float)Math.cos(angle2) * 0.5f;
                float nx = -((float)Math.sin(angle2)) * (float)Math.sin(angle1);
                float ny = (float)Math.sin(angle2) * (float)Math.cos(angle1);
                float nz = (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices[vertexIndex++] = vertex;
            }
        }
        Quad[] quads = new Quad[28];
        int quadIndex = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vertex v1 = vertices[i * 5 + j];
                Vertex v2 = vertices[(i + 1) * 5 + j];
                Vertex v3 = vertices[(i + 1) * 5 + (j + 1)];
                Vertex v4 = vertices[i * 5 + (j + 1)];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        Triangle[] fillTriangles = new Triangle[7];
        Vertex v1 = new Vertex(new Vector3(0.0f, 0.0f, 0.5f), TEXTURE_COORDINATES, new Vector3(0.0f, 0.0f, 1.0f));
        for (int i = 0; i < 7; ++i) {
            Vertex v2 = vertices[(i + 1) * 5];
            Vertex v3 = vertices[i * 5];
            fillTriangles[i] = new Triangle(v1, v2, v3);
        }
        Triangle[] allTriangles = MeshUtil.merge(MeshUtil.splitQuads(quads), fillTriangles);
        allTriangles = MeshUtil.mirrorHorizontal(allTriangles);
        allTriangles = MeshUtil.mirrorVertical(allTriangles);
        return new Mesh(allTriangles);
    }

    private Mesh createSpherePipe() {
        Vertex[] vertexes = new Vertex[64];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle1 = (double)i * Math.PI * 1.0 / 7.0;
            float x = -((float)Math.cos(angle1)) * 0.5f;
            float nx = -((float)Math.cos(angle1));
            for (int j = 0; j < 8; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float y = (float)Math.sin(angle1) * (float)Math.sin(angle2) * 0.5f;
                float z = (float)Math.sin(angle1) * (float)Math.cos(angle2) * 0.5f;
                float ny = (float)Math.sin(angle1) * (float)Math.sin(angle2);
                float nz = (float)Math.sin(angle1) * (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3(x, y, z), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertexes[vertexIndex++] = vertex;
            }
        }
        Quad[] quads = new Quad[56];
        int quadIndex = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                Vertex v1 = vertexes[i * 8 + j];
                Vertex v2 = vertexes[(i + 1) * 8 + j];
                Vertex v3 = vertexes[(i + 1) * 8 + (j + 1) % 8];
                Vertex v4 = vertexes[i * 8 + (j + 1) % 8];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        return new Mesh(quads);
    }

    @Override
    public void render(GL gl) {
        this.texture.bind(gl, this.phongShader, "texture");
        gl.glPushMatrix();
        gl.glTranslatef(0.5f, 0.5f, 0.5f);
        gl.glRotatef(-this.rotation * 90, 0.0f, 0.0f, 1.0f);
        this.mesh.render(gl);
        gl.glPopMatrix();
        this.texture.unbind(gl);
    }

    @Override
    public void render(RenderOptimizer renderOptimizer, Vector3 offset) {
        renderOptimizer.bindTexture(this.texture, this.phongShader, "texture");
        renderOptimizer.drawCustom(new RenderOptimizer.Drawable(){

            @Override
            public void render(GL gl) {
                gl.glPushMatrix();
                gl.glTranslatef(0.5f, 0.5f, 0.5f);
                gl.glRotatef(-Pipe.this.rotation * 90, 0.0f, 0.0f, 1.0f);
                Pipe.this.mesh.render(gl);
                gl.glPopMatrix();
            }
        }, offset);
        renderOptimizer.unbindTexture(this.texture);
    }

    static enum Shape {
        LEFT(BaseShape.END, 0),
        TOP(BaseShape.END, 1),
        RIGHT(BaseShape.END, 2),
        BOTTOM(BaseShape.END, 3),
        TOP_LEFT(BaseShape.CURVE, 0),
        TOP_RIGHT(BaseShape.CURVE, 1),
        LEFT_BOTTOM(BaseShape.CURVE, 3),
        RIGHT_BOTTOM(BaseShape.CURVE, 2),
        TOP_LEFT_RIGHT(BaseShape.JUNCTION, 0),
        TOP_LEFT_BOTTOM(BaseShape.JUNCTION, 3),
        TOP_RIGHT_BOTTOM(BaseShape.JUNCTION, 1),
        LEFT_RIGHT_BOTTOM(BaseShape.JUNCTION, 2),
        LEFT_RIGHT(BaseShape.STRAIGHT, 0),
        TOP_BOTTOM(BaseShape.STRAIGHT, 1),
        TOP_LEFT_RIGHT_BOTTOM(BaseShape.FULL, 0),
        SPHERE(BaseShape.NONE, 0);

        private final BaseShape baseShape;
        private final int rotation;

        private Shape(BaseShape baseShape, int rotation) {
            this.baseShape = baseShape;
            this.rotation = rotation;
        }
    }

    private static enum BaseShape {
        END,
        CURVE,
        JUNCTION,
        STRAIGHT,
        FULL,
        NONE;

    }
}

