/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl.tiles.torus;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.Mesh;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.MeshUtil;
import lonelycoders.ufohippa.client.gl.Quad;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.Triangle;
import lonelycoders.ufohippa.client.gl.Vertex;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.gl.Renderable;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.game.util.Vector3;

public class Torus
implements Renderable {
    private static final int DETAIL = 8;
    private static final Vector2 TEXTURE_COORDINATES = new Vector2(0.0f, 0.0f);
    private final MeshGL mesh;
    private final Shader phongShader;
    private final Texture texture;

    public Torus(ResourceManager resourceManager) {
        this.phongShader = resourceManager.getResource(GameResources.SHADER_PHONG_MULTILIGHT);
        this.texture = resourceManager.getResource(GameResources.WHITE_TEXTURE);
        this.mesh = resourceManager.addResource(new ResourceKey("Tile torus"), new ResourceCreator<MeshGL>(){

            @Override
            public MeshGL create() {
                return new MeshGL(Torus.this.createTorus(), MeshGL.RenderType.VERTEX_BUFFER);
            }
        });
    }

    private Mesh createTorus() {
        Vertex[] vertices = new Vertex[64];
        int vertexIndex = 0;
        for (int i = 0; i < 8; ++i) {
            double angle1 = (double)i * Math.PI * 0.5 / 7.0;
            float x1 = (float)(Math.sin(angle1) * 0.5 - 0.5);
            float y1 = (float)(0.5 - Math.cos(angle1) * 0.5);
            for (int j = 0; j < 8; ++j) {
                double angle2 = (double)j * Math.PI * 2.0 / 8.0;
                float x = x1 + -((float)Math.sin(angle2)) * 0.5f * (float)Math.sin(angle1);
                float y = y1 + (float)Math.sin(angle2) * 0.5f * (float)Math.cos(angle1);
                float z = (float)Math.cos(angle2) * 0.5f;
                float nx = -((float)Math.sin(angle2)) * (float)Math.sin(angle1);
                float ny = (float)Math.sin(angle2) * (float)Math.cos(angle1);
                float nz = (float)Math.cos(angle2);
                Vertex vertex = new Vertex(new Vector3((x + 0.5f) * 0.5f, (y - 0.5f) * 0.5f, z * 0.5f), TEXTURE_COORDINATES, new Vector3(nx, ny, nz));
                vertices[vertexIndex++] = vertex;
            }
        }
        Quad[] quads = new Quad[56];
        int quadIndex = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                Vertex v1 = vertices[i * 8 + j];
                Vertex v2 = vertices[(i + 1) * 8 + j];
                Vertex v3 = vertices[(i + 1) * 8 + (j + 1) % 8];
                Vertex v4 = vertices[i * 8 + (j + 1) % 8];
                quads[quadIndex++] = new Quad(v1, v2, v3, v4);
            }
        }
        Triangle[] allTriangles = MeshUtil.splitQuads(quads);
        allTriangles = MeshUtil.mirrorHorizontal(allTriangles);
        allTriangles = MeshUtil.mirrorVertical(allTriangles);
        return new Mesh(allTriangles);
    }

    @Override
    public void render(GL gl) {
        this.texture.bind(gl, this.phongShader, "texture");
        gl.glPushMatrix();
        gl.glTranslatef(0.5f, 0.5f, 0.5f);
        this.mesh.render(gl);
        gl.glPopMatrix();
        this.texture.unbind(gl);
    }

    @Override
    public void render(RenderOptimizer renderOptimizer, Vector3 offset) {
        renderOptimizer.bindTexture(this.texture, this.phongShader, "texture");
        renderOptimizer.drawMesh(this.mesh, new Vector3(offset.x + 0.5f, offset.y + 0.5f, offset.z + 0.5f));
        renderOptimizer.unbindTexture(this.texture);
    }
}

