/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.resource;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.resource.ResourceGL;
import lonelycoders.ufohippa.client.resource.ResourceLoader;
import lonelycoders.ufohippa.general.Logger;

public class DelayedResourceLoader
implements ResourceLoader {
    private final BlockingQueue<ResourceGL> loadQueue = new LinkedBlockingQueue<ResourceGL>();
    private final Queue<ResourceGL> finishQueue = new LinkedList<ResourceGL>();
    private boolean loading;
    private boolean finishing;
    private int loadedCount;
    private boolean active;

    public DelayedResourceLoader() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DelayedResourceLoader.this.run();
            }
        }, "Delayed resource loader").start();
    }

    @Override
    public <T extends ResourceGL> T enqueue(T resource) {
        try {
            this.loadQueue.put(resource);
        }
        catch (InterruptedException e) {
            Logger.exception(e);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(GL gl) {
        DelayedResourceLoader delayedResourceLoader = this;
        synchronized (delayedResourceLoader) {
            this.active = true;
            this.notify();
        }
        ResourceGL finish = this.finishQueue.poll();
        if (finish != null) {
            this.finishing = true;
            finish.loadGl(gl);
            ++this.loadedCount;
            this.finishing = false;
        }
    }

    public boolean isFinished() {
        return this.loadQueue.isEmpty() && !this.loading && this.finishQueue.isEmpty() && !this.finishing;
    }

    public float getStatus() {
        return (float)this.loadedCount / (float)(this.loadedCount + this.loadQueue.size() + this.finishQueue.size());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (true) {
            if (!this.active) {
                try {
                    DelayedResourceLoader delayedResourceLoader = this;
                    synchronized (delayedResourceLoader) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    Logger.exception(e);
                }
                continue;
            }
            try {
                ResourceGL resource = this.loadQueue.take();
                this.loading = true;
                resource.load();
                ++this.loadedCount;
                this.finishQueue.offer(resource);
                this.loading = false;
                this.active = false;
                continue;
            }
            catch (InterruptedException e) {
                Logger.exception(e);
                continue;
            }
            break;
        }
    }
}

