/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states.match;

import lonelycoders.ufohippa.game.Round;

public class ClientGameRunner {
    private final Object gameLock;
    private final GameRunnable runner;
    private final Round round;

    public ClientGameRunner(Round round, Object gameLock) {
        this.round = round;
        this.gameLock = gameLock;
        this.runner = new GameRunnable();
        Thread thread = new Thread((Runnable)this.runner, "Client game runner");
        thread.start();
    }

    public void start() {
        this.runner.start();
    }

    public void stop() {
        this.runner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(double deltaTime) {
        Object object = this.gameLock;
        synchronized (object) {
            this.round.update(deltaTime);
        }
    }

    private class GameRunnable
    implements Runnable {
        private final Object lock = new Object();
        private boolean alive = true;
        private boolean running = false;

        private GameRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long time = System.nanoTime();
            while (this.alive) {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.running) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        time = System.nanoTime();
                    }
                }
                if (!this.alive) continue;
                long currentTime = System.nanoTime();
                long deltaTime = currentTime - time;
                time = currentTime;
                ClientGameRunner.this.update((double)deltaTime / 1.0E9);
                try {
                    Thread.sleep(Math.max(0L, 10L - deltaTime / 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void start() {
            this.setRunning(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                this.alive = false;
                this.running = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRunning(boolean running) {
            Object object = this.lock;
            synchronized (object) {
                this.running = running;
                this.lock.notifyAll();
            }
        }
    }
}

