/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states.match;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.match.ClientMatchStartingState;
import lonelycoders.ufohippa.client.states.match.ClientResultsState;
import lonelycoders.ufohippa.client.states.match.ClientRoundState;
import lonelycoders.ufohippa.network.EmptyState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.StateManager;

public class ClientMatchStateManager
extends StateManager {
    private final ClientResultsState resultsState;
    private final ClientMatchStartingState matchStartingState;
    private final ClientRoundState roundState;
    private final State backToLobbyState = new EmptyState("Back to lobby");
    private State lobbyState;

    public ClientMatchStateManager(SoundManager soundManager, LevelManager levelManager, Object gameLock) {
        super("Match state manager");
        this.resultsState = new ClientResultsState(this.backToLobbyState);
        this.roundState = new ClientRoundState(soundManager, this.resultsState, gameLock);
        this.resultsState.setRoundState(this.roundState);
        this.matchStartingState = new ClientMatchStartingState(soundManager, levelManager, this.roundState);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setState(this.matchStartingState);
        }
    }

    @Override
    protected Set<State> getAvailableStates() {
        return new HashSet<State>(Arrays.asList(this.matchStartingState, this.roundState, this.resultsState, this.backToLobbyState));
    }

    @Override
    protected Map<State, State> getFinalStates() {
        HashMap<State, State> finalStates = new HashMap<State, State>();
        finalStates.put(this.backToLobbyState, this.lobbyState);
        return finalStates;
    }

    public ClientMatchStartingState getMatchStartingState() {
        return this.matchStartingState;
    }

    public ClientRoundState getRoundState() {
        return this.roundState;
    }

    public ClientResultsState getResultsState() {
        return this.resultsState;
    }

    public void setLobbyState(State lobbyState) {
        this.lobbyState = lobbyState;
    }
}

