/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.client.InputListener;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.match.ClientGameRunner;
import lonelycoders.ufohippa.client.states.match.ClientResultsState;
import lonelycoders.ufohippa.client.states.match.ClientRound;
import lonelycoders.ufohippa.client.states.match.Player;
import lonelycoders.ufohippa.game.InputStatus;
import lonelycoders.ufohippa.game.PlayerInputAction;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.ufo.Bullet;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.match.ClientDroppedCommand;
import lonelycoders.ufohippa.network.commands.match.EndRoundCommand;
import lonelycoders.ufohippa.network.commands.match.EndRoundReplyCommand;
import lonelycoders.ufohippa.network.commands.match.KeyUpdateCommand;
import lonelycoders.ufohippa.network.commands.match.RoundUpdateCommand;
import lonelycoders.ufohippa.network.commands.match.StartRoundCommand;
import lonelycoders.ufohippa.network.commands.match.StartRoundReplyCommand;
import lonelycoders.ufohippa.server.UpdateInfo;

public class ClientRoundState
extends CommandState
implements InputListener {
    private final SoundManager soundManager;
    private final ClientResultsState nextState;
    private final Object gameLock;
    private Map<String, Ufo> playerUfos;
    private Match match;
    private ClientRound currentRound;
    private int playingTime;
    private ClientGameRunner gameRunner;
    private final CommandHandler startRoundHandler = new StartRoundCommand.Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State process(StartRoundCommand payload) {
            ClientRoundState.this.sendCommand(new StartRoundReplyCommand());
            int roundNumber = payload.getRoundNumber();
            Level level = ClientRoundState.this.match.getLevels()[roundNumber];
            Vector2[] startingPositions = payload.getStartingPositions();
            ArrayList<Ufo> ufos = new ArrayList<Ufo>();
            ClientRoundState.this.playerUfos = new HashMap();
            for (Player player : ClientRoundState.this.match.getPlayers().values()) {
                int index = player.getIndex();
                Ufo ufo = new Ufo(player.getName(), startingPositions[index], false);
                ufo.setSkin(player.getSkin());
                ufos.add(ufo);
                ClientRoundState.this.playerUfos.put(player.getName(), ufo);
            }
            ClientRoundState.this.currentRound = new ClientRound(ClientRoundState.this.soundManager, level, ufos, ClientRoundState.this.playingTime);
            ClientRoundState.this.currentRound.setTagUfo((Ufo)ClientRoundState.this.playerUfos.get(payload.getStartTag()));
            ClientRoundState.this.gameRunner = new ClientGameRunner(ClientRoundState.this.currentRound, ClientRoundState.this.gameLock);
            ClientRoundState.this.gameRunner.start();
            Object i$ = ClientRoundState.this.gameLock;
            synchronized (i$) {
                ClientRoundState.this.match.startRound(ClientRoundState.this.currentRound, roundNumber);
            }
            SoundManager.MusicType musicType = LevelManager.isOldLevel(level.getDescriptor()) ? SoundManager.MusicType.OLD : SoundManager.MusicType.NEW;
            ClientRoundState.this.soundManager.playGameMusic(musicType);
            return null;
        }
    };
    private final CommandHandler roundUpdateHandler = new RoundUpdateCommand.Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State process(RoundUpdateCommand payload) {
            Object object = ClientRoundState.this.gameLock;
            synchronized (object) {
                Ufo ufo;
                for (RoundUpdateCommand.PlayerData playerData : payload.getPlayerDatas()) {
                    ufo = (Ufo)ClientRoundState.this.playerUfos.get(playerData.getName());
                    ufo.setPosition(playerData.getPosition());
                    ufo.setVelocity(playerData.getVelocity());
                    boolean[] controls = playerData.getControls();
                    for (int i = 0; i < controls.length; ++i) {
                        ufo.setControlState(Ufo.Control.values()[i], controls[i]);
                    }
                }
                for (RoundUpdateCommand.UfoCollision ufoCollision : payload.getUfoCollisions()) {
                    Ufo ufo1 = (Ufo)ClientRoundState.this.playerUfos.get(ufoCollision.getPlayer1Name());
                    Ufo ufo2 = (Ufo)ClientRoundState.this.playerUfos.get(ufoCollision.getPlayer2Name());
                    String newTagName = ufoCollision.getNewTagName();
                    Object object2 = ClientRoundState.this.gameLock;
                    synchronized (object2) {
                        if (newTagName != null) {
                            ClientRoundState.this.currentRound.setTagUfo((Ufo)ClientRoundState.this.playerUfos.get(newTagName));
                        }
                    }
                    float strength = ufoCollision.getStrength();
                    if (!(strength > 0.002f)) continue;
                    ClientRoundState.this.soundManager.playEffectUfoCollision();
                }
                for (RoundUpdateCommand.BulletShootData shootData : payload.getShootDatas()) {
                    ufo = (Ufo)ClientRoundState.this.playerUfos.get(shootData.getPlayerName());
                    Bullet bullet = new Bullet(shootData.getBounceProbability(), shootData.getPosition(), shootData.getVelocity(), ufo.getBulletColor());
                    Object newTagName = ClientRoundState.this.gameLock;
                    synchronized (newTagName) {
                        ClientRoundState.this.currentRound.addBullet(shootData.getBulletId(), bullet);
                    }
                    ClientRoundState.this.soundManager.playEffectShoot();
                }
                for (RoundUpdateCommand.BulletHit bulletHit : payload.getBulletHits()) {
                    int bulletId = bulletHit.getBulletId();
                    String playerName = bulletHit.getPlayerName();
                    if (playerName != null) {
                        Ufo ufo2 = (Ufo)ClientRoundState.this.playerUfos.get(playerName);
                        Object object3 = ClientRoundState.this.gameLock;
                        synchronized (object3) {
                            ClientRoundState.this.currentRound.bulletHitUfo(bulletId, ufo2);
                        }
                        ClientRoundState.this.soundManager.playEffectBulletHit();
                        continue;
                    }
                    ClientRoundState.this.currentRound.bulletHitWall(bulletId);
                }
                for (UpdateInfo.SoundEffect soundEffect : payload.getSoundEffects()) {
                    switch (soundEffect) {
                        case TELEPORT: {
                            ClientRoundState.this.soundManager.playEffectTeleport();
                            break;
                        }
                        case WALL_COLLISION: {
                            ClientRoundState.this.soundManager.playEffectWallCollision();
                        }
                    }
                }
                ClientRoundState.this.currentRound.serverSynchronized();
                return null;
            }
        }
    };
    private final CommandHandler endRoundHandler = new EndRoundCommand.Handler(){

        @Override
        public State process(EndRoundCommand payload) {
            for (Ufo ufo : ClientRoundState.this.playerUfos.values()) {
                for (Ufo.Control control : Ufo.Control.values()) {
                    ufo.setControlState(control, false);
                }
            }
            ClientRoundState.this.soundManager.stopMusic(true);
            ClientRoundState.this.gameRunner.stop();
            ClientRoundState.this.sendCommand(new EndRoundReplyCommand());
            return ClientRoundState.this.nextState;
        }
    };
    private final CommandHandler dropHandler = new ClientDroppedCommand.Handler(){

        @Override
        public State process(ClientDroppedCommand payload) {
            for (String playerName : payload.getPlayerNames()) {
                ClientRoundState.this.match.getPlayers().remove(playerName);
                ClientRoundState.this.currentRound.dropPlayers(payload.getPlayerNames());
            }
            return null;
        }
    };

    public ClientRoundState(SoundManager soundManager, ClientResultsState nextState, Object gameLock) {
        super("Round", new CommandHandler[0]);
        this.soundManager = soundManager;
        this.nextState = nextState;
        this.gameLock = gameLock;
        this.registerHandlers(this.startRoundHandler, this.roundUpdateHandler, this.endRoundHandler, this.dropHandler);
    }

    public void setMatch(Match match) {
        this.match = match;
        this.nextState.setMatch(match);
    }

    @Override
    public void setInputActionState(PlayerInputAction action, boolean pressed) {
        if (this.isActiveState() && this.currentRound != null) {
            this.sendCommand(new KeyUpdateCommand(new InputStatus[]{new InputStatus(action, pressed)}));
        }
    }

    @Override
    public void continuePressed() {
    }

    public void setPlayingTime(int playingTime) {
        this.playingTime = playingTime;
    }
}

