/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game;

import java.util.Collection;
import lonelycoders.ufohippa.game.RoundBase;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.ufo.Ufo;

public abstract class Round
extends RoundBase {
    protected double synchronizedTimeLeftOver;
    protected double unsynchronizedTimeLeftOver;
    protected double remainingTime;

    public Round(Level level, Collection<Ufo> ufos, int playingTime) {
        super(level, ufos);
        for (Ufo ufo : ufos) {
            this.tagTimes.put(ufo, 0.0);
        }
        this.remainingTime = playingTime * 60;
    }

    public void update(double deltaTime) {
        this.synchronizedTimeLeftOver += deltaTime;
        if (this.synchronizedTimeLeftOver >= 0.01) {
            while (this.synchronizedTimeLeftOver >= 0.01) {
                this.synchronizedTimeLeftOver -= 0.01;
                this.updateConstantRate();
            }
            this.updateOnce();
        }
        this.unsynchronizedTimeLeftOver += deltaTime;
        while (this.unsynchronizedTimeLeftOver >= 0.01) {
            this.unsynchronizedTimeLeftOver -= 0.01;
            this.updateUnsynchronizedConstantRate();
        }
        this.remainingTime -= deltaTime;
        if (this.remainingTime < 0.0) {
            this.remainingTime = 0.0;
        }
    }

    public int getRemainingSeconds() {
        return (int)Math.ceil(this.remainingTime);
    }

    protected void updateOnce() {
    }

    public int getFrameCounter() {
        return this.frameCounter;
    }
}

