/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import lonelycoders.ufohippa.game.ai.pathfindingai.Estimator;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelUtil;

public class EscapeEstimator
implements Estimator {
    private final Level level;
    private final LevelUtil.TilePosition tagPosition;

    public EscapeEstimator(Level level, LevelUtil.TilePosition tagPosition) {
        this.level = level;
        this.tagPosition = tagPosition;
        int levelWidth = level.getWidth();
        int levelHeight = level.getHeight();
    }

    @Override
    public float getEstimate(LevelUtil.TilePosition currentPosition) {
        int deltaX = this.tagPosition.getX() - currentPosition.getX();
        int deltaY = this.tagPosition.getY() - currentPosition.getY();
        float distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        float estimate = (float)Math.pow(distance, 0.2f) * 1000.0f;
        return 1000000.0f - estimate;
    }

    @Override
    public boolean isFinished(int iteration, LevelUtil.TilePosition position) {
        return iteration == 1000;
    }

    @Override
    public float getPositionPenalty(int tileX, int tileY) {
        int adjacentBlocked = 0;
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX, tileY - 1)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX - 1, tileY)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX + 1, tileY)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX, tileY + 1)) {
            ++adjacentBlocked;
        }
        float[] penalties = new float[]{0.0f, 0.4f, 0.5f, 0.6f, 0.7f};
        return penalties[adjacentBlocked];
    }
}

