/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import java.util.LinkedList;
import lonelycoders.ufohippa.game.ai.pathfindingai.RouteNode;
import lonelycoders.ufohippa.game.level.LevelUtil;

public class Route {
    private final LinkedList<RouteNode> nodes = new LinkedList();

    public Route(RouteNode endNode) {
        RouteNode node = endNode;
        while (node.getPreviousNode() != null) {
            this.nodes.add(0, node);
            node = node.getPreviousNode();
        }
    }

    private void printRoute() {
        System.out.print("Route: ");
        for (RouteNode node : this.nodes) {
            LevelUtil.TilePosition position = node.getPosition();
            System.out.print(position.getX() + "," + position.getY() + " - ");
        }
        System.out.println();
    }

    public LevelUtil.TilePosition getFirst() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.getFirst().getPosition();
    }

    public Iterable<RouteNode> getNodes() {
        return this.nodes;
    }
}

