/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ufo;

import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector2;

public class Bullet {
    public static final float SIZE = 0.1f;
    private float bounceProbability;
    private final Vector2 position = new Vector2(0.0f, 0.0f);
    private final Vector2 velocity = new Vector2(0.0f, 0.0f);
    private final ColorRGB color;
    private float mass;
    private boolean alive;

    public Bullet(float bounceProbability, Vector2 position, Vector2 velocity, ColorRGB color) {
        this.bounceProbability = bounceProbability;
        this.setPosition(position);
        this.setVelocity(velocity);
        this.color = color;
        this.alive = true;
    }

    public Bullet(Bullet original) {
        this(original.bounceProbability, new Vector2(original.position), new Vector2(original.velocity), original.color);
        this.alive = original.alive;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public void setPosition(float x, float y) {
        this.position.x = x;
        this.position.y = y;
    }

    public void setPosition(Vector2 position) {
        this.position.x = position.x;
        this.position.y = position.y;
    }

    public void setVelocity(Vector2 velocity) {
        this.velocity.x = velocity.x;
        this.velocity.y = velocity.y;
    }

    public void update() {
        this.position.add(this.velocity);
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public float getBounceProbability() {
        return this.bounceProbability;
    }

    public void setBounceProbability(float bounceProbability) {
        this.bounceProbability = bounceProbability;
    }

    public boolean isAlive() {
        return this.alive;
    }
}

