/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.util;

import java.awt.Color;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import lonelycoders.ufohippa.game.util.Vector3;
import lonelycoders.ufohippa.general.Logger;

public class ColorRGB {
    public static final ColorRGB WHITE = new ColorRGB(1.0f, 1.0f, 1.0f);
    public static final ColorRGB BLACK = new ColorRGB(0.0f, 0.0f, 0.0f);
    public static final ColorRGB RED = new ColorRGB(1.0f, 0.0f, 0.0f);
    public static final ColorRGB GREEN = new ColorRGB(0.0f, 1.0f, 0.0f);
    public static final ColorRGB BLUE = new ColorRGB(0.0f, 0.0f, 1.0f);
    public static final ColorRGB ORANGE = new ColorRGB(1.0f, 1.0f, 0.0f);
    public static final ColorRGB PINK = new ColorRGB(1.0f, 0.0f, 1.0f);
    public static final ColorRGB CYAN = new ColorRGB(0.0f, 1.0f, 1.0f);
    public static final ColorRGB LIGHT_GRAY = new ColorRGB(0.75f, 0.75f, 0.75f);
    public static final ColorRGB GRAY = new ColorRGB(0.5f, 0.5f, 0.5f);
    public static final ColorRGB DARK_GRAY = new ColorRGB(0.25f, 0.25f, 0.25f);
    private final float red;
    private final float green;
    private final float blue;

    public ColorRGB(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColorRGB(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    public ColorRGB(ColorRGB color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
    }

    public ColorRGB blend(ColorRGB other, float factor) {
        return new ColorRGB((1.0f - factor) * this.red + factor * other.red, (1.0f - factor) * this.green + factor * other.green, (1.0f - factor) * this.blue + factor * other.blue);
    }

    public ColorRGB blend(float brightness) {
        return new ColorRGB(brightness * this.red, brightness * this.green, brightness * this.blue);
    }

    public ColorRGB multiply(ColorRGB color) {
        return new ColorRGB(this.red * color.red, this.green * color.green, this.blue * color.blue);
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public String toString() {
        return "ColorRGB{" + this.red + "," + this.green + "," + this.blue + '}';
    }

    public Color toAwtColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public Vector3 toVector() {
        return new Vector3(this.red, this.green, this.blue);
    }

    public float distanceTo(ColorRGB other) {
        Vector3 v1 = this.toVector();
        Vector3 v2 = other.toVector();
        Vector3 diff = new Vector3(v2);
        diff.sub(v1);
        return diff.getLength() / (float)Math.sqrt(3.0);
    }

    public String asString(char separator) {
        return "[" + this.red + separator + this.green + separator + this.blue + "]";
    }

    public static ColorRGB fromString(String string) {
        ColorRGB color = null;
        if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            StringTokenizer st = new StringTokenizer(string.substring(1, string.length() - 1), ",;");
            try {
                float red = Float.parseFloat(st.nextToken());
                float green = Float.parseFloat(st.nextToken());
                float blue = Float.parseFloat(st.nextToken());
                color = new ColorRGB(red, green, blue);
            }
            catch (NoSuchElementException e) {
                Logger.exception(e);
            }
            catch (NumberFormatException e) {
                Logger.exception(e);
            }
        }
        return color;
    }
}

