/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.util;

public class Vector2 {
    public float x;
    public float y;
    public static final Vector2 UP = new Vector2(0.0f, 1.0f);
    public static final Vector2 DOWN = new Vector2(0.0f, -1.0f);
    public static final Vector2 LEFT = new Vector2(-1.0f, 0.0f);
    public static final Vector2 RIGHT = new Vector2(1.0f, 0.0f);

    public Vector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(float x, float y, boolean normalize) {
        this(x, y);
        if (normalize) {
            this.normalize();
        }
    }

    public Vector2(Vector2 other) {
        this(other.x, other.y);
    }

    public void add(Vector2 other) {
        this.x += other.x;
        this.y += other.y;
    }

    public void sub(Vector2 other) {
        this.x -= other.x;
        this.y -= other.y;
    }

    public void multiply(Vector2 other) {
        this.x *= other.x;
        this.y *= other.y;
    }

    public void divide(Vector2 other) {
        this.x /= other.x;
        this.y /= other.y;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
    }

    public void addScaled(Vector2 other, float scale) {
        this.x += other.x * scale;
        this.y += other.y * scale;
    }

    public void blend(Vector2 other, float factor) {
        this.x = this.x * (1.0f - factor) + other.x * factor;
        this.y = this.y * (1.0f - factor) + other.y * factor;
    }

    public float dot(Vector2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public float getLength() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float getLength2() {
        return this.x * this.x + this.y * this.y;
    }

    public void normalize() {
        float length = this.getLength();
        this.x /= length;
        this.y /= length;
    }

    public void inverse() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
    }

    public void reflect(Vector2 normal, float factor) {
        float dot = this.dot(normal);
        if (dot < 0.0f) {
            this.x -= (1.0f + factor) * normal.x * dot;
            this.y -= (1.0f + factor) * normal.y * dot;
        }
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector2 vector2 = (Vector2)o;
        return Float.compare(vector2.x, this.x) == 0 && Float.compare(vector2.y, this.y) == 0;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        return result;
    }

    public String toString() {
        return "Vector2{" + this.x + ", " + this.y + '}';
    }
}

