/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.general;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import lonelycoders.ufohippa.general.logger.ConsoleLoggerHandler;
import lonelycoders.ufohippa.general.logger.LoggerHandler;

public class Logger {
    private static final Collection<LoggerRegistration> handlers = new ArrayList<LoggerRegistration>();

    public static void registerLogger(LoggerHandler handler, Level tolerance) {
        handlers.add(new LoggerRegistration(tolerance, handler));
    }

    public static void log(Level level, String message) {
        Calendar calendar = Calendar.getInstance();
        for (LoggerRegistration handler : handlers) {
            if (level.priority > handler.tolerance.priority) continue;
            handler.handler.handle(level, Thread.currentThread().getName(), calendar.getTime(), message);
        }
    }

    public static void exception(Throwable t, String message) {
        String prefix = "[" + Thread.currentThread().getName() + "]: ";
        if (message != null) {
            System.err.println("EXCEPTION " + prefix + message);
            System.err.println(prefix + t);
        } else {
            System.err.println("EXCEPTION " + prefix + t);
        }
        for (StackTraceElement element : t.getStackTrace()) {
            System.err.println(prefix + element);
        }
    }

    public static void exception(Throwable t) {
        Logger.exception(t, null);
    }

    public static void warning(String message) {
        Logger.log(Level.WARNING, message);
    }

    public static void tempDebug(String message) {
        Logger.log(Level.TEMP_DEBUG, message);
    }

    public static void info(String message) {
        Logger.log(Level.INFO, message);
    }

    public static void debug(String message) {
        Logger.log(Level.DEBUG, message);
    }

    public static void detail(String message) {
        Logger.log(Level.DETAIL, message);
    }

    static {
        Logger.registerLogger(new ConsoleLoggerHandler(), Level.TEMP_DEBUG);
    }

    private static class LoggerRegistration {
        private Level tolerance;
        private LoggerHandler handler;

        private LoggerRegistration(Level tolerance, LoggerHandler handler) {
            this.tolerance = tolerance;
            this.handler = handler;
        }
    }

    public static enum Level {
        WARNING(2),
        TEMP_DEBUG(5),
        INFO(10),
        DEBUG(50),
        DETAIL(100);

        private int priority;

        private Level(int priority) {
            this.priority = priority;
        }
    }
}

