/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.leveleditor.gl;

import com.sun.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lonelycoders.ufohippa.client.gl.Camera;
import lonelycoders.ufohippa.client.gl.Composer;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.gl.GameRenderer;
import lonelycoders.ufohippa.client.renderer.gl.LoadingScreenRenderer;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.Round;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.util.ColorRGBA;
import lonelycoders.ufohippa.game.util.Vector3;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.leveleditor.LevelEditor;

public class OpenGLLevelEditorRenderer
implements GLEventListener {
    private final Object lock;
    private final ResourceManager resourceManager;
    private final JPanel panel;
    private final GLAutoDrawable glPanel;
    private final AnimationTimer animationTimer;
    private final Animator animator;
    private Round round;
    private GameRenderer gameRenderer;
    private CursorRenderer cursorRenderer;
    private Composer gameComposer;
    private LoadingScreenRenderer loadingScreenRenderer;
    private boolean active = false;
    private long time;
    private UtilGL.PositionState positionState;
    private Point mouseCoordinates;
    private Camera camera;
    private InputHandler inputHandler;
    private LevelEditor.Tool tool;

    public OpenGLLevelEditorRenderer(Object lock, ResourceManager resourceManager) {
        this.lock = lock;
        this.resourceManager = resourceManager;
        GLCanvas glPanel = new GLCanvas();
        glPanel.setBackground(Color.black);
        glPanel.addGLEventListener(this);
        MouseHandler mouseHandler = new MouseHandler();
        glPanel.addMouseListener(mouseHandler);
        glPanel.addMouseMotionListener(mouseHandler);
        this.glPanel = glPanel;
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBackground(Color.black);
        this.panel.add((Component)glPanel, "Center");
        this.animationTimer = new AnimationTimer();
        this.animator = new Animator(glPanel);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForActive() {
        OpenGLLevelEditorRenderer openGLLevelEditorRenderer = this;
        synchronized (openGLLevelEditorRenderer) {
            while (!this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.exception(e);
                }
            }
        }
    }

    public void initialize(Round round) {
        this.round = round;
        this.gameRenderer.loadRound(round);
        this.camera = this.gameRenderer.new GameRenderer.FullLevelCamera();
        this.gameRenderer.setCamera(this.camera);
        this.time = System.nanoTime();
        this.animationTimer.reset();
    }

    public void loadTileSet(TileSet tileSet) {
        this.gameRenderer.loadTileSet(tileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GLAutoDrawable drawable) {
        this.resourceManager.clear();
        GeneralResources.load(this.resourceManager);
        GL gl = drawable.getGL();
        float[] lightAmbient = new float[]{0.0f, 0.0f, 0.0f};
        float[] lightDiffuse = new float[]{0.8f, 0.8f, 0.8f};
        gl.glEnable(16384);
        gl.glLightfv(16384, 4608, lightAmbient, 0);
        gl.glLightfv(16384, 4609, lightDiffuse, 0);
        float[] specular = new float[]{1.0f, 1.0f, 1.0f};
        gl.glEnable(2903);
        gl.glColorMaterial(1032, 5634);
        gl.glMaterialfv(1032, 4610, specular, 0);
        gl.glMaterialf(1032, 5633, 30.0f);
        gl.glEnable(2884);
        gl.glEnable(2977);
        gl.glLightModeli(2897, 1);
        float[] globalAmbient = new float[]{0.3f, 0.3f, 0.3f};
        gl.glLightModelfv(2899, globalAmbient, 0);
        gl.glHint(3152, 4354);
        this.animationTimer.reset();
        this.gameRenderer = new GameRenderer(this.glPanel, this.resourceManager, this.animationTimer);
        this.cursorRenderer = new CursorRenderer(this.resourceManager);
        this.gameComposer = new Composer(RenderTarget.SCREEN_TARGET, this.gameRenderer, this.cursorRenderer);
        this.loadingScreenRenderer = new LoadingScreenRenderer(RenderTarget.SCREEN_TARGET, this.glPanel, gl, this.animationTimer);
        this.positionState = UtilGL.getPositionState(gl);
        try {
            UtilGL.checkErrors(gl);
        }
        catch (GLException e) {
            e.printStackTrace();
        }
        OpenGLLevelEditorRenderer openGLLevelEditorRenderer = this;
        synchronized (openGLLevelEditorRenderer) {
            this.active = true;
            this.notifyAll();
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.animator.start();
        } else {
            this.animator.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable drawable) {
        Object object = this.lock;
        synchronized (object) {
            long currentTime = System.nanoTime();
            long deltaTime = currentTime - this.time;
            this.time = currentTime;
            this.update((double)deltaTime / 1.0E9);
            try {
                this.render(drawable.getGL());
            }
            catch (GLException e) {
                e.printStackTrace();
            }
        }
    }

    private void update(double deltaTime) {
        this.animationTimer.update(deltaTime);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    @Override
    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    private void render(GL gl) throws GLException {
        if (!this.resourceManager.getResourceLoader().isFinished()) {
            this.resourceManager.getResourceLoader().update(gl);
            this.loadingScreenRenderer.render(gl);
        } else if (this.round != null) {
            this.gameComposer.render(gl);
            this.positionState = UtilGL.getPositionState(gl);
            UtilGL.checkErrors(gl);
        } else {
            gl.glClear(16640);
            UtilGL.checkErrors(gl);
        }
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public void setTool(LevelEditor.Tool tool) {
        this.tool = tool;
    }

    private int[] getTileCoordinates(Point point) {
        float screenZ = UtilGL.getScreenPosition((UtilGL.PositionState)this.positionState, (Vector3)new Vector3((float)0.0f, (float)0.0f, (float)1.0f)).z;
        Vector3 worldPosition = UtilGL.getWorldPosition(this.positionState, new Vector3(point.x, this.glPanel.getHeight() - point.y, screenZ));
        float x = Math.round(worldPosition.x - 0.5f);
        float y = Math.round(worldPosition.y - 0.5f);
        return new int[]{(int)x, (int)y};
    }

    public static interface InputHandler {
        public void mousePressed(int var1, int var2, boolean var3, MouseEvent var4);

        public void mouseReleased(int var1, int var2, boolean var3);

        public void mouseDragged(int var1, int var2, boolean var3, MouseEvent var4);
    }

    private class MouseHandler
    extends MouseAdapter {
        private boolean leftButton;

        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            OpenGLLevelEditorRenderer.this.mouseCoordinates = e.getPoint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            OpenGLLevelEditorRenderer.this.mouseCoordinates = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (OpenGLLevelEditorRenderer.this.round != null) {
                OpenGLLevelEditorRenderer.this.mouseCoordinates = e.getPoint();
                int[] coordinates = OpenGLLevelEditorRenderer.this.getTileCoordinates(OpenGLLevelEditorRenderer.this.mouseCoordinates);
                int tileX = coordinates[0];
                int tileY = coordinates[1];
                if (tileX >= 1 && tileX < OpenGLLevelEditorRenderer.this.round.getLevel().getWidth() - 1 && tileY >= 1 && tileY < OpenGLLevelEditorRenderer.this.round.getLevel().getHeight() - 1) {
                    OpenGLLevelEditorRenderer.this.inputHandler.mouseDragged(tileX, tileY, this.leftButton, e);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (OpenGLLevelEditorRenderer.this.round != null) {
                OpenGLLevelEditorRenderer.this.mouseCoordinates = e.getPoint();
                int[] coordinates = OpenGLLevelEditorRenderer.this.getTileCoordinates(OpenGLLevelEditorRenderer.this.mouseCoordinates);
                this.leftButton = e.getButton() == 1;
                int tileX = coordinates[0];
                int tileY = coordinates[1];
                if (tileX >= 1 && tileX < OpenGLLevelEditorRenderer.this.round.getLevel().getWidth() - 1 && tileY >= 1 && tileY < OpenGLLevelEditorRenderer.this.round.getLevel().getHeight() - 1) {
                    OpenGLLevelEditorRenderer.this.inputHandler.mousePressed(tileX, tileY, this.leftButton, e);
                }
            }
        }
    }

    private class CursorRenderer
    extends RenderPass {
        private final MeshGL tileCube;

        public CursorRenderer(ResourceManager resourceManager) {
            this.tileCube = resourceManager.getResource(GameResources.TILE_CUBE);
        }

        @Override
        public void doRender(GL gl) throws GLException {
            if (OpenGLLevelEditorRenderer.this.round != null) {
                OpenGLLevelEditorRenderer.this.camera.apply(gl);
                if (OpenGLLevelEditorRenderer.this.mouseCoordinates != null) {
                    int[] coordinates = OpenGLLevelEditorRenderer.this.getTileCoordinates(OpenGLLevelEditorRenderer.this.mouseCoordinates);
                    Level level = OpenGLLevelEditorRenderer.this.round.getLevel();
                    gl.glPushMatrix();
                    switch (OpenGLLevelEditorRenderer.this.tool) {
                        case DRAW: {
                            gl.glTranslatef(coordinates[0], coordinates[1], 0.0f);
                            gl.glScalef(1.1f, 1.1f, 1.1f);
                            gl.glTranslatef(-0.05f, -0.05f, -0.05f);
                            UtilGL.applyColorWithAlpha(gl, new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f));
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            this.tileCube.render(gl);
                            UtilGL.disableBlend(gl);
                            break;
                        }
                        case TELEPORT_NORMAL: 
                        case TELEPORT_ANYWHERE: {
                            ColorRGBA color;
                            gl.glTranslatef((float)coordinates[0] + 0.5f, (float)coordinates[1] + 0.5f, 0.0f);
                            if (OpenGLLevelEditorRenderer.this.tool == LevelEditor.Tool.TELEPORT_NORMAL) {
                                color = new ColorRGBA(0.0f, 0.5f, 1.0f, 0.5f);
                            } else if (OpenGLLevelEditorRenderer.this.tool == LevelEditor.Tool.TELEPORT_ANYWHERE) {
                                color = new ColorRGBA(1.0f, 0.25f, 0.25f, 0.5f);
                            } else {
                                throw new IllegalStateException();
                            }
                            UtilGL.applyColorWithAlpha(gl, color);
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            UtilGL.drawSquare(gl, 0.0f, 0.0f, 0.1f, 0.4f);
                            UtilGL.disableBlend(gl);
                            break;
                        }
                        case ADD_COLUMN: {
                            gl.glTranslatef(coordinates[0], 0.0f, 0.0f);
                            gl.glTranslatef(-0.05f, -0.05f, -0.05f);
                            gl.glScalef(1.1f, (float)level.getHeight() + 0.1f, 1.1f);
                            UtilGL.applyColorWithAlpha(gl, new ColorRGBA(0.0f, 1.0f, 0.0f, 0.5f));
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            this.tileCube.render(gl);
                            UtilGL.disableBlend(gl);
                            break;
                        }
                        case REMOVE_COLUMN: {
                            gl.glTranslatef(coordinates[0], 0.0f, 0.0f);
                            gl.glTranslatef(-0.05f, -0.05f, -0.05f);
                            gl.glScalef(1.1f, (float)level.getHeight() + 0.1f, 1.1f);
                            UtilGL.applyColorWithAlpha(gl, new ColorRGBA(1.0f, 0.0f, 0.0f, 0.5f));
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            this.tileCube.render(gl);
                            UtilGL.disableBlend(gl);
                            break;
                        }
                        case ADD_ROW: {
                            gl.glTranslatef(0.0f, coordinates[1], 0.0f);
                            gl.glTranslatef(-0.05f, -0.05f, -0.05f);
                            gl.glScalef((float)level.getWidth() + 0.1f, 1.1f, 1.1f);
                            UtilGL.applyColorWithAlpha(gl, new ColorRGBA(0.0f, 1.0f, 0.0f, 0.5f));
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            this.tileCube.render(gl);
                            UtilGL.disableBlend(gl);
                            break;
                        }
                        case REMOVE_ROW: {
                            gl.glTranslatef(0.0f, coordinates[1], 0.0f);
                            gl.glTranslatef(-0.05f, -0.05f, -0.05f);
                            gl.glScalef((float)level.getWidth() + 0.1f, 1.1f, 1.1f);
                            UtilGL.applyColorWithAlpha(gl, new ColorRGBA(1.0f, 0.0f, 0.0f, 0.5f));
                            UtilGL.enableBlend(gl, UtilGL.BlendMode.ALPHA_BLEND);
                            this.tileCube.render(gl);
                            UtilGL.disableBlend(gl);
                        }
                    }
                    gl.glPopMatrix();
                }
            }
        }
    }
}

