/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.NetworkProtocolException;

public abstract class Command {
    public abstract int getId();

    public abstract void serialize(DataOutputStream var1) throws NetworkProtocolException, IOException;

    public String toString() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != Command.class) {
            clazz = clazz.getSuperclass();
        }
        StringBuilder sb = new StringBuilder(clazz.getSimpleName());
        sb.append('{');
        Field[] declaredFields = clazz.getDeclaredFields();
        boolean first = true;
        for (Field field : declaredFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(field.getName());
                sb.append('=');
                field.setAccessible(true);
                Object value = field.get(this);
                if (value == null) {
                    sb.append("null");
                    continue;
                }
                if (field.getType().isArray()) {
                    sb.append(Arrays.asList((Object[])value));
                    continue;
                }
                sb.append(value);
            }
            catch (IllegalAccessException e) {
                Logger.exception(e);
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

