/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network;

import java.io.DataInputStream;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.network.State;

public abstract class StateManager
extends State {
    private State currentState;

    public StateManager(String name) {
        super(name);
    }

    public void setState(State newState) {
        assert (this.getAvailableStates().contains(newState));
        if (this.currentState != null) {
            this.currentState.setActive(false);
        }
        this.currentState = newState;
        Logger.detail("Changing state to \"" + newState + "\"");
        newState.setActive(true);
    }

    @Override
    public State readCommand(DataInputStream dis) throws NetworkProtocolException {
        State newState = this.currentState.readCommand(dis);
        if (newState != null) {
            this.setState(newState);
            return this.getFinalStates().get(newState);
        }
        return null;
    }

    @Override
    public void connected(CommandSender commandSender) throws NetworkProtocolException {
        super.connected(commandSender);
        for (State state : this.getAvailableStates()) {
            state.connected(commandSender);
        }
    }

    protected abstract Set<State> getAvailableStates();

    protected abstract Map<State, State> getFinalStates();
}

