/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.lobby;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class ServerSendMessageCommand
extends Command {
    private static final int ID = 206;
    private final String clientName;
    private final String message;

    public ServerSendMessageCommand(String clientName, String message) {
        this.clientName = clientName;
        this.message = message;
    }

    public ServerSendMessageCommand(DataInputStream dis) throws IOException {
        this.clientName = dis.readUTF();
        this.message = dis.readUTF();
    }

    @Override
    public int getId() {
        return 206;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.clientName);
        dos.writeUTF(this.message);
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getMessage() {
        return this.message;
    }

    public static abstract class Handler
    extends CommandHandler<ServerSendMessageCommand> {
        @Override
        public int getId() {
            return 206;
        }

        @Override
        public ServerSendMessageCommand deserialize(DataInputStream dis) throws IOException {
            return new ServerSendMessageCommand(dis);
        }
    }
}

