/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class EndRoundCommand
extends Command {
    private static final int ID = 308;
    private final Map<String, Double> playerTagTimes;

    public EndRoundCommand(Map<String, Double> playerTagTimes) {
        this.playerTagTimes = playerTagTimes;
    }

    @Override
    public int getId() {
        return 308;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerTagTimes.size());
        for (Map.Entry<String, Double> entry : this.playerTagTimes.entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeDouble(entry.getValue());
        }
    }

    public static abstract class Handler
    extends CommandHandler<EndRoundCommand> {
        @Override
        public int getId() {
            return 308;
        }

        @Override
        public EndRoundCommand deserialize(DataInputStream dis) throws IOException {
            HashMap<String, Double> playerTagTimes = new HashMap<String, Double>();
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                playerTagTimes.put(dis.readUTF(), dis.readDouble());
            }
            return new EndRoundCommand(playerTagTimes);
        }
    }
}

