/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.game.InputStatus;
import lonelycoders.ufohippa.game.PlayerInputAction;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class KeyUpdateCommand
extends Command {
    private static final int ID = 400;
    private final InputStatus[] statusUpdates;

    public KeyUpdateCommand(InputStatus[] statusUpdates) {
        this.statusUpdates = statusUpdates;
    }

    public InputStatus[] getStatusUpdates() {
        return this.statusUpdates;
    }

    @Override
    public int getId() {
        return 400;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.statusUpdates.length);
        for (InputStatus status : this.statusUpdates) {
            dos.writeInt(status.getAction().getOrdinal());
            dos.writeBoolean(status.isPressed());
        }
    }

    public static abstract class Handler
    extends CommandHandler<KeyUpdateCommand> {
        @Override
        public int getId() {
            return 400;
        }

        @Override
        public KeyUpdateCommand deserialize(DataInputStream dis) throws IOException {
            int statusCount = dis.readInt();
            InputStatus[] statusUpdates = new InputStatus[statusCount];
            for (int i = 0; i < statusCount; ++i) {
                PlayerInputAction action = PlayerInputAction.fromOrdinal(dis.readInt());
                boolean isPressed = dis.readBoolean();
                statusUpdates[i] = new InputStatus(action, isPressed);
            }
            return new KeyUpdateCommand(statusUpdates);
        }
    }
}

