/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.game.RoundResults;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class RoundResultsCommand
extends Command {
    private static final int ID = 310;
    private final RoundResults roundResults;

    public RoundResultsCommand(RoundResults roundResults) {
        this.roundResults = roundResults;
    }

    public RoundResults getRoundResults() {
        return this.roundResults;
    }

    @Override
    public int getId() {
        return 310;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        Map<String, Double> playerTagTimes = this.roundResults.getPlayerTagTimes();
        Map<String, Integer> playerPoints = this.roundResults.getOldPlayerPoints();
        Map<String, Integer> newPlayerPoints = this.roundResults.getAddedPlayerPoints();
        dos.writeInt(playerPoints.size());
        for (String playerName : playerPoints.keySet()) {
            dos.writeUTF(playerName);
            dos.writeDouble(playerTagTimes.get(playerName));
            dos.writeInt(playerPoints.get(playerName));
            dos.writeInt(newPlayerPoints.get(playerName));
        }
    }

    public static abstract class Handler
    extends CommandHandler<RoundResultsCommand> {
        @Override
        public int getId() {
            return 310;
        }

        @Override
        public RoundResultsCommand deserialize(DataInputStream dis) throws IOException {
            HashMap<String, Double> playerTagTimes = new HashMap<String, Double>();
            HashMap<String, Integer> playerPoints = new HashMap<String, Integer>();
            HashMap<String, Integer> newPlayerPoints = new HashMap<String, Integer>();
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                String playerName = dis.readUTF();
                playerTagTimes.put(playerName, dis.readDouble());
                playerPoints.put(playerName, dis.readInt());
                newPlayerPoints.put(playerName, dis.readInt());
            }
            return new RoundResultsCommand(new RoundResults(playerTagTimes, playerPoints, newPlayerPoints));
        }
    }
}

