/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import lonelycoders.ufohippa.game.ai.AIController;
import lonelycoders.ufohippa.game.ai.pathfindingai.PathFindingAI;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.CommandQueue;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.general.StoppableThread;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.network.commands.lobby.AllBasicSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.AllLevelSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.AllPlayerSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.PlayerSettingsCommandReply;
import lonelycoders.ufohippa.network.commands.lobby.ServerSendMessageCommand;
import lonelycoders.ufohippa.network.commands.lobby.StartGameCommand;
import lonelycoders.ufohippa.network.commands.match.ClientDroppedCommand;
import lonelycoders.ufohippa.server.ClientId;
import lonelycoders.ufohippa.server.ServerCommander;
import lonelycoders.ufohippa.server.ServerCommunicator;
import lonelycoders.ufohippa.server.ServerData;
import lonelycoders.ufohippa.server.SharedContext;
import lonelycoders.ufohippa.server.SharedContextCommander;
import lonelycoders.ufohippa.server.model.AllServerSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;
import lonelycoders.ufohippa.server.states.ServerStateManager;

public class Server
implements SharedContextCommander {
    public static final int DEFAULT_PORT = 13579;
    private static final Object LOCK = new Object();
    private final Map<ClientId, SocketHandler> unregisteredClients = new HashMap<ClientId, SocketHandler>();
    private final Map<ClientId, SocketHandler> clients = new HashMap<ClientId, SocketHandler>();
    private StoppableThread connectionListener;
    private CommandQueue commandQueue;
    private volatile ServerSocket serverSocket;
    private volatile CountDownLatch preSynchronizer;
    private volatile CountDownLatch postSynchronizer;
    private volatile boolean synchronizing = false;
    private final ServerData serverData = new ServerData(new ServerCommanderImpl());
    private final AllServerSettings allServerSettings = new AllServerSettings();
    private SharedContext sharedContext;
    private int uniqueId = 0;

    public Server() {
        this.allServerSettings.addListener(new AllServerSettings.Listener(){

            @Override
            public void basicSettingsChanged(int maxPlayers, int playingTime, int aiPlayers, boolean bonusItems, boolean publicGame, boolean allowJoiningDuringGame) {
                Server.this.broadcastCommand(Server.createAllBasicSettingsCommand(playingTime, aiPlayers, bonusItems));
                String[] names = new String[aiPlayers];
                ColorRGB[] colors = new ColorRGB[aiPlayers];
                AIController[] controllers = new AIController[aiPlayers];
                for (int i = 0; i < aiPlayers; ++i) {
                    String name = "Computer";
                    if (aiPlayers > 1) {
                        name = name + " " + (i + 1);
                    }
                    names[i] = name;
                    colors[i] = ColorRGB.WHITE;
                    controllers[i] = new PathFindingAI();
                }
                Server.this.serverData.setAIPlayersSettings(names, colors, controllers);
            }

            @Override
            public void levelsChanged(List<LevelDescriptor> levels) {
                Server.this.broadcastCommand(Server.createAllLevelSettingsCommand(levels));
            }

            @Override
            public void playersChanged(List<PlayerInfo> players) {
                for (SocketHandler socketHandler : Server.this.clients.values()) {
                    if (!socketHandler.stateManager.getLobbyState().isActiveState()) continue;
                    try {
                        socketHandler.sendCommand(Server.createAllPlayerSettingsCommand(players));
                    }
                    catch (NetworkProtocolException e) {
                        socketHandler.stop();
                        Logger.exception(e);
                    }
                }
            }
        });
    }

    private static AllBasicSettingsCommand createAllBasicSettingsCommand(int playingTime, int aiPlayers, boolean bonusItems) {
        return new AllBasicSettingsCommand(playingTime, aiPlayers, bonusItems);
    }

    private static AllLevelSettingsCommand createAllLevelSettingsCommand(Collection<LevelDescriptor> levels) {
        String[] levelNames = new String[levels.size()];
        int i = 0;
        for (LevelDescriptor level : levels) {
            levelNames[i++] = level.getName();
        }
        return new AllLevelSettingsCommand(levelNames.length, levelNames);
    }

    private static AllPlayerSettingsCommand createAllPlayerSettingsCommand(List<PlayerInfo> players) {
        int playerCount = players.size();
        String[] names = new String[playerCount];
        ColorRGB[] colors = new ColorRGB[playerCount];
        int i = 0;
        for (PlayerInfo player : players) {
            names[i] = player.getName();
            colors[i] = player.getColor();
            ++i;
        }
        return new AllPlayerSettingsCommand(playerCount, names, colors);
    }

    public AllServerSettings getAllServerSettings() {
        return this.allServerSettings;
    }

    public void startGame() {
        this.commandQueue.addTask(new Runnable(){

            @Override
            public void run() {
                Logger.info("Starting game");
                try {
                    ServerSocket socket = Server.this.serverSocket;
                    Server.this.serverSocket = null;
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    Logger.exception(e);
                }
                Server.this.sharedContext.startGame(Server.this.allServerSettings);
                Server.this.broadcastCommand(new StartGameCommand());
            }
        });
    }

    public void start() {
        this.sharedContext = new SharedContext(this);
        try {
            this.serverSocket = new ServerSocket(13579);
        }
        catch (IOException e) {
            Logger.exception(e);
            throw new RuntimeException("Unable to listen TCP port 13579");
        }
        if (this.commandQueue == null) {
            this.commandQueue = new CommandQueue("Server command processor");
            this.commandQueue.start();
        }
        this.connectionListener = new StoppableThread("Server socket listener", new Runnable(){

            @Override
            public void run() {
                Server.this.acceptConnections();
            }
        });
        this.commandQueue.addTask(new Runnable(){

            @Override
            public void run() {
                Logger.info("Started game server");
                Server.this.connectionListener.start();
            }
        });
    }

    private void acceptConnections() {
        try {
            Logger.info("Accepting connections");
            Socket socket = this.serverSocket.accept();
            ClientId clientId = new ClientId(socket.getInetAddress(), socket.getPort(), this.uniqueId++);
            Logger.info("Client " + clientId + " accepted");
            try {
                SocketHandler socketHandler = new SocketHandler(socket, clientId);
                this.unregisteredClients.put(clientId, socketHandler);
            }
            catch (NetworkProtocolException e) {
                Logger.exception(e);
            }
        }
        catch (SocketException e) {
            if (this.serverSocket == null) {
                Logger.info("No longer accepting connections");
                this.connectionListener.stop();
            } else {
                Logger.exception(e);
            }
        }
        catch (ClosedByInterruptException e) {
            Logger.exception(e);
        }
        catch (IOException e) {
            Logger.exception(e);
        }
    }

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public void close() {
        this.commandQueue.addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket socket = Server.this.serverSocket;
                    if (socket != null) {
                        Server.this.serverSocket = null;
                        socket.close();
                    }
                }
                catch (IOException e) {
                    Logger.exception(e);
                }
                for (SocketHandler socketHandler : new ArrayList(Server.this.clients.values())) {
                    socketHandler.stop();
                }
                for (SocketHandler socketHandler : new ArrayList(Server.this.unregisteredClients.values())) {
                    socketHandler.stop();
                }
                Server.this.commandQueue.stop();
                Server.this.commandQueue = null;
            }
        });
    }

    public boolean isLocalGame() {
        return this.clients.size() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dropClient(ClientId clientId) {
        if (!this.serverData.isRegisteredClient(clientId)) {
            return;
        }
        String[] playerNames = this.serverData.getClientPlayers(clientId);
        if (this.unregisteredClients.containsKey(clientId)) {
            this.unregisteredClients.remove(clientId);
        }
        if (this.clients.containsKey(clientId)) {
            this.clients.remove(clientId);
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.synchronizing) {
                this.preSynchronizer.countDown();
                this.postSynchronizer.countDown();
            }
        }
        this.serverData.removeClient(clientId);
        for (SocketHandler socketHandler : this.clients.values()) {
            if (!socketHandler.stateManager.getMatchState().isActiveState()) continue;
            try {
                socketHandler.sendCommand(new ClientDroppedCommand(playerNames));
            }
            catch (NetworkProtocolException e) {
                socketHandler.stop();
                Logger.exception(e);
            }
        }
    }

    @Override
    public void broadcastCommand(Command command) {
        if (!this.clients.isEmpty()) {
            Logger.detail("Broadcasting command " + command + " to " + this.clients.size() + " clients");
            for (SocketHandler socketHandler : this.clients.values()) {
                try {
                    socketHandler.sendCommand(command);
                }
                catch (NetworkProtocolException e) {
                    socketHandler.stop();
                    Logger.exception(e);
                }
            }
        }
    }

    private class ServerCommunicatorImpl
    implements ServerCommunicator {
        private final ClientId clientId;

        public ServerCommunicatorImpl(ClientId clientId) {
            this.clientId = clientId;
        }

        @Override
        public void playerSettingsChanged(final int playerCount, final String[] playerNames, final ColorRGB[] playerColors) {
            Server.this.commandQueue.addTask(new Runnable(){

                @Override
                public void run() {
                    Logger.info("Client " + ServerCommunicatorImpl.this.clientId + " registered with " + playerCount + " players");
                    boolean changedPlayerSettings = Server.this.serverData.ensureValidPlayerSettings(ServerCommunicatorImpl.this.clientId, playerNames, playerColors);
                    Server.this.serverData.setPlayerSettings(ServerCommunicatorImpl.this.clientId, playerNames, playerColors);
                    if (changedPlayerSettings) {
                        SocketHandler socketHandler = (SocketHandler)Server.this.clients.get(ServerCommunicatorImpl.this.clientId);
                        try {
                            socketHandler.sendCommand(new PlayerSettingsCommandReply(playerCount, playerNames, playerColors));
                        }
                        catch (NetworkProtocolException e) {
                            socketHandler.stop();
                            Logger.exception(e);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void synchronize(Object key, Runnable sharedCommand) {
            Logger.info("Synchronizing...");
            boolean first = false;
            Object object = LOCK;
            synchronized (object) {
                if (!Server.this.synchronizing) {
                    Server.this.synchronizing = true;
                    first = true;
                    Server.this.preSynchronizer = new CountDownLatch(Server.this.clients.size());
                    Server.this.postSynchronizer = new CountDownLatch(Server.this.clients.size());
                }
            }
            try {
                Server.this.preSynchronizer.countDown();
                Server.this.preSynchronizer.await();
                if (first) {
                    Logger.info("Synchronized " + Server.this.clients.size() + " clients");
                    if (sharedCommand != null) {
                        sharedCommand.run();
                    }
                    Server.this.synchronizing = false;
                }
                Server.this.postSynchronizer.countDown();
                Server.this.postSynchronizer.await();
            }
            catch (InterruptedException e) {
                Logger.exception(e);
            }
        }

        @Override
        public void synchronize(Object key) {
            this.synchronize(key, null);
        }

        @Override
        public SharedContext getSharedContext() {
            return Server.this.sharedContext;
        }

        @Override
        public void clientRegistered() {
            SocketHandler socketHandler = (SocketHandler)Server.this.unregisteredClients.remove(this.clientId);
            assert (socketHandler != null);
            Server.this.clients.put(this.clientId, socketHandler);
            try {
                socketHandler.sendCommand(Server.createAllBasicSettingsCommand(Server.this.allServerSettings.getBasicSettings().getPlayingTime(), Server.this.allServerSettings.getBasicSettings().getAiPlayers(), Server.this.allServerSettings.getBasicSettings().isBonusItems()));
                socketHandler.sendCommand(Server.createAllPlayerSettingsCommand(Server.this.allServerSettings.getPlayers()));
                socketHandler.sendCommand(Server.createAllLevelSettingsCommand(Server.this.allServerSettings.getLevels()));
            }
            catch (NetworkProtocolException e) {
                socketHandler.stop();
                Logger.exception(e);
            }
        }

        @Override
        public void messageReceived(String message) {
            String clientName = Server.this.serverData.getClientPlayers(this.clientId)[0];
            Server.this.broadcastCommand(new ServerSendMessageCommand(clientName, message));
        }

        @Override
        public String[] getClientPlayers() {
            return Server.this.serverData.getClientPlayers(this.clientId);
        }
    }

    private class ServerCommanderImpl
    implements ServerCommander {
        private ServerCommanderImpl() {
        }

        @Override
        public void playerSettingsChanged(ServerData.PlayerInfo[] playerInfos) {
            int playerCount = playerInfos.length;
            PlayerInfo[] newPlayers = new PlayerInfo[playerCount];
            for (int i = 0; i < playerCount; ++i) {
                ServerData.PlayerInfo playerInfo = playerInfos[i];
                newPlayers[i] = new PlayerInfo(playerInfo.getName(), playerInfo.getColor(), playerInfo.getAiController(), playerInfo.isAiPlayer());
            }
            Server.this.allServerSettings.setPlayers(newPlayers);
        }
    }

    private class SocketHandler
    extends CommandSender
    implements Runnable {
        private final Socket socket;
        private final ClientId clientId;
        private boolean alive;
        private final DataInputStream dis;
        private final DataOutputStream dos;
        private final ServerStateManager stateManager;

        public SocketHandler(Socket socket, ClientId clientId) throws NetworkProtocolException {
            super("Server handler " + clientId.getId() + " command sender");
            this.alive = true;
            this.socket = socket;
            this.clientId = clientId;
            try {
                this.dis = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                this.dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            }
            catch (IOException e) {
                throw new NetworkProtocolException(e);
            }
            this.stateManager = new ServerStateManager(new ServerCommunicatorImpl(clientId));
            Thread thread = new Thread((Runnable)this, "Server handler " + clientId.getId());
            thread.start();
        }

        @Override
        public void run() {
            try {
                this.stateManager.connected(this);
            }
            catch (NetworkProtocolException e) {
                this.exceptionCaught(e);
            }
            while (this.alive) {
                try {
                    this.stateManager.readCommand(this.dis);
                }
                catch (NetworkProtocolException e) {
                    this.exceptionCaught(e);
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.exception(e);
            }
        }

        @Override
        public void stop() {
            super.stop();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.exception(e);
            }
        }

        @Override
        public String getTarget() {
            return this.clientId.toString();
        }

        @Override
        public DataOutputStream getDataOutputStream() {
            return this.dos;
        }

        @Override
        public void exceptionCaught(NetworkProtocolException e) {
            this.alive = false;
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                Logger.exception(e1);
            }
            Server.this.dropClient(this.clientId);
        }
    }
}

