/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.StateManager;
import lonelycoders.ufohippa.network.commands.initial.HelloCommand;
import lonelycoders.ufohippa.server.ServerCommunicator;
import lonelycoders.ufohippa.server.states.ServerLobbyState;
import lonelycoders.ufohippa.server.states.match.ServerMatchStateManager;

public class ServerStateManager
extends StateManager {
    private final ServerCommunicator serverCommander;
    private final State initialState;
    private final ServerMatchStateManager matchState;
    private final ServerLobbyState lobbyState;
    private final CommandHandler helloHandler = new HelloCommand.Handler(){

        @Override
        public State process(HelloCommand payload) {
            ServerStateManager.this.sendCommand(new HelloCommand());
            ServerStateManager.this.serverCommander.clientRegistered();
            return ServerStateManager.this.lobbyState;
        }
    };

    public ServerStateManager(ServerCommunicator serverCommander) {
        super("General state manager");
        this.serverCommander = serverCommander;
        this.matchState = new ServerMatchStateManager(serverCommander);
        this.lobbyState = new ServerLobbyState(serverCommander, this.matchState);
        this.initialState = new CommandState("Initial", this.helloHandler);
        this.matchState.setLobbyState(this.lobbyState);
    }

    public ServerMatchStateManager getMatchState() {
        return this.matchState;
    }

    @Override
    public void connected(CommandSender commandSender) throws NetworkProtocolException {
        super.connected(commandSender);
        this.setActive(true);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setState(this.initialState);
        }
    }

    @Override
    protected Set<State> getAvailableStates() {
        return new HashSet<State>(Arrays.asList(this.initialState, this.lobbyState, this.matchState));
    }

    @Override
    protected Map<State, State> getFinalStates() {
        return new HashMap<State, State>();
    }

    public State getLobbyState() {
        return this.lobbyState;
    }
}

