/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states.match;

import java.util.List;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.lobby.AllBasicSettingsCommand;
import lonelycoders.ufohippa.network.commands.match.MatchStartingCommand;
import lonelycoders.ufohippa.network.commands.match.MatchStartingReplyCommand;
import lonelycoders.ufohippa.network.commands.match.SendLevelsCommand;
import lonelycoders.ufohippa.network.commands.match.SendLevelsReplyCommand;
import lonelycoders.ufohippa.network.commands.match.SendPlayersCommand;
import lonelycoders.ufohippa.server.ServerCommunicator;
import lonelycoders.ufohippa.server.model.BasicSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;
import lonelycoders.ufohippa.server.model.ServerMatch;

public class ServerMatchStartingState
extends CommandState {
    private final ServerCommunicator serverCommander;
    private final State nextState;
    private static final Object MATCH_STARTING = "MATCH_STARTING";
    private static final Object SEND_LEVELS = "SEND_LEVELS";
    private final CommandHandler matchStartingReplyHandler = new MatchStartingReplyCommand.Handler(){

        @Override
        public State process(MatchStartingReplyCommand payload) {
            ServerMatchStartingState.this.serverCommander.synchronize(MATCH_STARTING);
            ServerMatchStartingState.this.matchStarting();
            return null;
        }
    };
    private final CommandHandler sendLevelsReplyHandler = new SendLevelsReplyCommand.Handler(){

        @Override
        public State process(SendLevelsReplyCommand payload) {
            ServerMatchStartingState.this.serverCommander.synchronize(SEND_LEVELS, new Runnable(){

                @Override
                public void run() {
                    ServerMatchStartingState.this.serverCommander.getSharedContext().initializeNextRound();
                }
            });
            return ServerMatchStartingState.this.nextState;
        }
    };

    public ServerMatchStartingState(ServerCommunicator serverCommander, State nextState) {
        super("Starting game", new CommandHandler[0]);
        this.serverCommander = serverCommander;
        this.nextState = nextState;
        this.registerHandlers(this.matchStartingReplyHandler, this.sendLevelsReplyHandler);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.sendCommand(new MatchStartingCommand(this.serverCommander.getClientPlayers()));
        }
    }

    private void matchStarting() {
        List<PlayerInfo> players = this.serverCommander.getSharedContext().getPlayers();
        int playerCount = players.size();
        String[] names = new String[playerCount];
        ColorRGB[] colors = new ColorRGB[playerCount];
        int i = 0;
        for (PlayerInfo player : players) {
            names[i] = player.getName();
            colors[i] = player.getColor();
            ++i;
        }
        this.sendCommand(new SendPlayersCommand(playerCount, names, colors));
        BasicSettings basicSettings = this.serverCommander.getSharedContext().getBasicSettings();
        this.sendCommand(new AllBasicSettingsCommand(basicSettings.getPlayingTime(), basicSettings.getAiPlayers(), basicSettings.isBonusItems()));
        ServerMatch serverMatch = this.serverCommander.getSharedContext().getMatch();
        LevelDescriptor[] levels = serverMatch.getLevels();
        String[] levelNames = new String[levels.length];
        for (int i2 = 0; i2 < levels.length; ++i2) {
            levelNames[i2] = levels[i2].getName();
        }
        this.sendCommand(new SendLevelsCommand(levelNames));
    }
}

