/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states.match;

import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.match.ContinueCommand;
import lonelycoders.ufohippa.network.commands.match.ContinueReplyCommand;
import lonelycoders.ufohippa.network.commands.match.MatchEndedCommand;
import lonelycoders.ufohippa.network.commands.match.RoundResultsCommand;
import lonelycoders.ufohippa.server.ServerCommunicator;

public class ServerResultsState
extends CommandState {
    private final ServerCommunicator serverCommander;
    private State nextRoundState;
    private State backToLobbyState;
    private static final Object CONTINUE = "Continue";
    private CommandHandler continueHandler = new ContinueCommand.Handler(){

        @Override
        public State process(ContinueCommand payload) {
            if (ServerResultsState.this.serverCommander.getSharedContext().hashMoreRounds()) {
                ServerResultsState.this.serverCommander.synchronize(CONTINUE, new Runnable(){

                    @Override
                    public void run() {
                        ServerResultsState.this.serverCommander.getSharedContext().initializeNextRound();
                    }
                });
                ServerResultsState.this.sendCommand(new ContinueReplyCommand());
                return ServerResultsState.this.nextRoundState;
            }
            ServerResultsState.this.sendCommand(new MatchEndedCommand());
            return ServerResultsState.this.backToLobbyState;
        }
    };

    public ServerResultsState(ServerCommunicator serverCommander, State backToLobbyState) {
        super("Results", new CommandHandler[0]);
        this.serverCommander = serverCommander;
        this.backToLobbyState = backToLobbyState;
        this.registerHandlers(this.continueHandler);
    }

    public void setNextRoundState(State nextState) {
        this.nextRoundState = nextState;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.sendCommand(new RoundResultsCommand(this.serverCommander.getSharedContext().getRoundResults()));
        }
    }
}

