/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lonelycoders.ufohippa.util.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static Element parseXml(File file) throws IOException, XmlException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public static Element parseXml(InputStream is) throws IOException, XmlException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(is).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
    }

    public static void saveXml(Element element, File path) throws XmlException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(element.getOwnerDocument()), new StreamResult(path));
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException(e);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
    }

    public static Element createXml(String rootElementName) throws XmlException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = document.createElement(rootElementName);
            document.appendChild(element);
            return element;
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
    }

    public static Element getChildElement(Element element, String childName) throws XmlException {
        NodeList nodes = element.getElementsByTagName(childName);
        if (nodes.getLength() == 0) {
            throw new XmlException("Child element \"" + childName + "\" not found from element \"" + element.getNodeName() + "\"");
        }
        if (nodes.getLength() > 1) {
            throw new XmlException("Child element \"" + childName + "\" is not unique in element \"" + element.getNodeName() + "\"");
        }
        return (Element)nodes.item(0);
    }

    public static Iterable<Element> getChildElements(Element element, String childName) throws XmlException {
        NodeList nodes = element.getElementsByTagName(childName);
        ArrayList<Element> children = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            children.add((Element)nodes.item(i));
        }
        return children;
    }

    public static int getIntAttribute(Element element, String attributeName) throws XmlException {
        String value = element.getAttribute(attributeName);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new XmlException("Attribute \"" + attributeName + "\" not found from element \"" + element.getNodeName() + "\"");
        }
    }

    public static int getIntAttribute(Element element, String attributeName, int defaultValue) {
        try {
            return Integer.parseInt(element.getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean getBooleanAttribute(Element element, String attributeName) throws XmlException {
        String value = element.getAttribute(attributeName);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new XmlException("Attribute \"" + attributeName + "\" not found from element \"" + element.getNodeName() + "\"");
        }
    }

    public static boolean getBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(element.getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getStringAttribute(Element element, String attributeName) throws XmlException {
        if (!element.hasAttribute(attributeName)) {
            throw new XmlException("Attribute \"" + attributeName + "\" not found from element \"" + element.getNodeName() + "\"");
        }
        return element.getAttribute(attributeName);
    }

    public static String getStringAttribute(Element element, String attributeName, String defaultValue) {
        if (!element.hasAttribute(attributeName)) {
            return defaultValue;
        }
        return element.getAttribute(attributeName);
    }

    public static String getElementText(Element element) {
        return element.getTextContent();
    }

    public static void setElementText(Element element, String text) {
        element.setTextContent(text);
    }

    public static boolean hasChild(Element element, String childName) {
        return element.getElementsByTagName(childName).getLength() == 1;
    }

    public static void setAttribute(Element elementLevel, String key, String value) {
        elementLevel.setAttribute(key, value);
    }

    public static void setAttribute(Element elementLevel, String key, int value) {
        elementLevel.setAttribute(key, "" + value);
    }

    public static Element createChildElement(Element element, String childElementName) {
        Element childElement = element.getOwnerDocument().createElement(childElementName);
        element.appendChild(childElement);
        return childElement;
    }
}

