uniform float uTimer;
uniform vec3 uColor1;
uniform vec3 uColor2;
uniform sampler2D uTexture;

void main() {
	vec2 coordinate = gl_TexCoord[0].xy;
	float distance = texture2D(uTexture, coordinate).r;
	
	float timer = uTimer + coordinate.x * 0.1 - coordinate.y * 0.2;
	float checkDistance = sin(timer) * 0.3 + 0.4;

	float inside = clamp((checkDistance - distance) * 10.0, 0.0, 1.0);
	vec4 color1 = vec4(uColor1, 1.0);
	vec4 color2 = vec4(uColor2, 1.0);
	gl_FragColor = mix(color1, color2, inside);
}
