

#include "MainMenu.h"

#include "Game.h"

#include "SongEditor.h"

#include "SongSelect.h"

#include "VuvuzelaHero.h"

MainMenu::MainMenu(BGSpinner* spinner) : m_spinner(spinner), m_selected(0)
{
    m_items.append(START_GAME);
    m_items.append(SONG_EDITOR);
    m_items.append(EXIT);
}

MainMenu::~MainMenu()
{

}

void MainMenu::start()
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
    m_timer.start(20);
    m_spinner->start();
    
    vuvuzelaHero->noise->play();
    
    m_time.start();
}
void MainMenu::stop()
{
    
}

void MainMenu::timeout()
{
    vuvuzelaHero->updateGL();
}

void MainMenu::keyPressEvent(QKeyEvent* e)
{
    if(e->key() == Qt::Key_Down){
        if(m_selected == m_items.size() - 1)
            m_selected = 0;
        else
            ++m_selected;
    } else if(e->key() == Qt::Key_Up){
        if(m_selected == 0)
            m_selected = m_items.size() - 1;
        else
            --m_selected;
    } else if(e->key() == Qt::Key_Return){
        Item item = m_items[m_selected];
        if(item == START_GAME){
            vuvuzelaHero->setScene(new SongSelect(new Game()));
        } else if(item == SONG_EDITOR){
            vuvuzelaHero->setScene(new SongSelect(new SongEditor()));
        } else if(item == EXIT){
            QApplication::exit();
        }
    }
    
}
    
void MainMenu::paint(QSize size)
{
    glViewport(0,0, size.width(), size.height());
    
    glColor3f(1.0, 1.0, 1.0);
    glClearColor(1,1,1, 1.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity( );
    glOrtho(0, size.width(), size.height(), 0, -1.0, 1.0);
    
    glMatrixMode(GL_MODELVIEW);
    
    glLoadIdentity();
    
    vuvuzelaHero->drawTexture(QRectF(0, 0, size.width(), size.height()), vuvuzelaHero->menubg);
    
    glMatrixMode( GL_PROJECTION );
    glPushMatrix();
    
    m_spinner->paint(size);
    
    glMatrixMode( GL_PROJECTION );
    glPopMatrix();
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    glColor3f(1,1,1);
    
    vuvuzelaHero->drawTexture(QRectF(size.width()/4, 0, size.width()/4 * 2, size.height()/3), vuvuzelaHero->logo);
    
    float y = size.height()/3 + 100;
    
    QPainter p;
    p.begin(vuvuzelaHero);
    
    
    QFont font("Sans", 40, QFont::Bold);
    p.setFont(font);
    
    int num = 0;
    
    QList<Item>::iterator it = m_items.begin();
    while(it != m_items.end()){
       
        float x = size.width()/2 - p.fontMetrics().width(itemToText(*it))/2;
        
        if(m_selected == num){
            int32_t ms = (m_time.elapsed()/1000.0 - floor(m_time.elapsed()/1000.0)) * 1000 - 500;
        
            double diff;
            diff  = (pow(ms + (ms < 0 ? 250 : -250), 2));
            
            //250^2 = 62500
            diff -= 62500;
            
            if(ms < 0)
            diff *= -1;
          
            x += diff * 0.001;
        }

        vuvuzelaHero->drawText(p, QPoint(x,y), itemToText(*it));
        
        y += p.fontMetrics().height() + 10;
        
        ++num;
        ++it;
    }
    
    p.end();
}


QString MainMenu::itemToText(MainMenu::Item item)
{
    if(item == START_GAME)
        return "Start Game";
    else if(item == SONG_EDITOR)
        return "Song Editor";
    else if(item == EXIT)
        return "Exit";
    
    return QString();
}

void MainMenu::startItem(MainMenu::Item item)
{

}



#include "MainMenu.moc"