#include "SongEditor.h"

#include "MainMenu.h"

#include "VuvuzelaHero.h"

SongEditor::SongEditor() : m_playing(false)
{
    beat = 0;
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
}
SongEditor::~SongEditor()
{

}

void SongEditor::start()
{
    m_spinner.start();
    m_timer.start(20);
    if(song->beats.size() == 0){
        song->beats.append(0);
    }
}

void SongEditor::stop()
{

}

void SongEditor::timeout()
{
    if(m_playing && floor(beat) == song->beats.size() - 1){
        m_playing = false;
        note = 0;
        m_vuvuzela.stop();
    }
    if(m_playing){
        beat += 20/1000.0/60.0 * song->bpm;
        if(floor(beat) > floor(m_lastbeat)){
            note = song->beats[floor(beat)];
            if(note > 0 && song->beats[floor(m_lastbeat)] != note){
                m_vuvuzela.play(note);
            } else if(note == 0){
                //m_vuvuzela->seek(m_vuvuzela->totalTime() - 50);
                //m_vuvuzela.stop();
                m_vuvuzela.delayedStop();
            }
        }
        m_lastbeat = beat;
    }
    
    vuvuzelaHero->updateGL();
}

void SongEditor::clearmsg()
{
    m_msg = "";
}


void SongEditor::keyPressEvent(QKeyEvent* e)
{
    if(e->key() == Qt::Key_Up){
        ++beat;
        if(beat == song->beats.size()){
            song->beats.append(0);
        }
    } else if(e->key() == Qt::Key_Down){
        if(beat > 0){
            --beat;
            
            if(beat == song->beats.size() - 2 && song->beats[song->beats.size() - 1] == 0)
                song->beats.erase(song->beats.end() - 1);
        }
    } else if(e->key() == Qt::Key_Home){
        beat = 0;
    } else if(e->key() == Qt::Key_End){
        beat = song->beats.size() - 1;
    } else if(e->key() == Qt::Key_Insert){
        song->beats.insert(floor(beat), 0);
    } else if(e->key() == Qt::Key_Delete){
        song->beats.erase(song->beats.begin() + floor(beat));
        if(beat > 0)
            --beat;
    } else if(e->key() == Qt::Key_Escape){
        vuvuzelaHero->setScene(new MainMenu());
        return;
    } else if(e->key() == Qt::Key_S){
        if(song->saveFile())
            m_msg = "Song saved";
        else
            m_msg = "Saving failed";
        QTimer::singleShot(2000, this, SLOT(clearmsg()));
    } else if(e->key() == Qt::Key_P){
        if(!m_playing){
            m_playing = true;
            m_lastbeat = beat;
        } else {
            m_playing = false;
            note = 0;
            m_vuvuzela.stop();
            beat = floor(beat);
        }
    }
    
    int newnote = 0;
    
    if(e->key() == Qt::Key_1)
        newnote = 1;
    if(e->key() == Qt::Key_2 && song->difficulty > Song::EASY)
        newnote = 2;
    if(e->key() == Qt::Key_3 && song->difficulty > Song::MEDIUM)
        newnote = 3;
    if(e->key() == Qt::Key_4 && song->difficulty > Song::HARD)
        newnote = 4;
    
    if(newnote)
        noteSwitch(newnote);
}

void SongEditor::keyReleaseEvent(QKeyEvent* )
{

}


void SongEditor::paint(QSize size)
{
    glClearColor(0.9, 0.4, 0.0, 1.0);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    
    m_spinner.paint(size);
    
    paintField(size);
    
    glColor3f(0.8,1,1);
    
    QPainter p;
    p.begin(vuvuzelaHero);
    
    p.setFont(QFont("Sans", 30, QFont::Bold));
    p.setPen(QPen(QColor(255,255,255)));
    
    if(m_msg.size()){
        p.setPen(QPen(QColor(0,0,0)));
        p.drawText(QPointF(20, p.fontMetrics().height()+13), m_msg);
        p.setPen(QPen(QColor(127,29,29)));
        p.drawText(QPointF(20, p.fontMetrics().height()+10), m_msg);
    }
    QString beatstr;
    QTextStream stream(&beatstr);
    stream << "Beat ";
    stream << floor(beat);
    
    p.setPen(QPen(QColor(0,0,0)));
    p.drawText(QPointF(size.width() - p.fontMetrics().width(beatstr) - 10 + 3, p.fontMetrics().height()+13), beatstr);
    p.setPen(QPen(QColor(127,29,29)));
    p.drawText(QPointF(size.width() - p.fontMetrics().width(beatstr) - 10, p.fontMetrics().height()+10), beatstr);
    
    p.end();
}


void SongEditor::noteSwitch(int newnote)
{
    while(floor(beat) >= song->beats.size())
        song->beats.append(0);
    
    if(song->beats[floor(beat)] == newnote){
        song->beats[floor(beat)] = 0;
    } else 
        song->beats[floor(beat)] = newnote;
}


#include "SongEditor.moc"