#include "TitleScreen.h"

#include "VuvuzelaHero.h"

#include "MainMenu.h"

TitleScreen::TitleScreen(BGSpinner* spinner) : m_spinner(spinner)
{
}

TitleScreen::~TitleScreen()
{

}

void TitleScreen::start()
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
    m_timer.start(20);
    m_spinner->start();
    
    vuvuzelaHero->noise->play();
}
void TitleScreen::stop()
{
    
}

void TitleScreen::timeout()
{
    vuvuzelaHero->updateGL();
}

void TitleScreen::keyPressEvent ( QKeyEvent* )
{
    vuvuzelaHero->setScene(new MainMenu(m_spinner));
}
    
void TitleScreen::paint ( QSize size )
{
    glViewport(0,0, size.width(), size.height());
    
    glColor3f(1.0, 1.0, 1.0);
    glClearColor(1,1,1, 1.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glMatrixMode( GL_PROJECTION );
    glPushMatrix();
    glLoadIdentity( );
    glOrtho(0, size.width(), size.height(), 0, -1.0, 1.0);
    
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();
    
    vuvuzelaHero->drawTexture(QRectF(0, 0, size.width(), size.height()), vuvuzelaHero->menubg);
    
    glMatrixMode( GL_PROJECTION );
    glPushMatrix();
    
    m_spinner->paint(size);
    
    glMatrixMode( GL_PROJECTION );
    glPopMatrix();
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    glColor3f(1,1,1);
    
    vuvuzelaHero->drawTexture(QRectF(size.width()/4, size.height()/3, size.width()/4 * 2, size.height()/3), vuvuzelaHero->logo);
    
    glMatrixMode( GL_PROJECTION );
    glPopMatrix();
    
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
    
    glColor3f(.9,.9,.9);
    
    QPainter p;
    p.begin(vuvuzelaHero);
    
    QString presskey = "Press any key";
    
    p.setFont(QFont("Sans", 40, QFont::Bold));
    vuvuzelaHero->drawText(p, QPoint(size.width()/2 - p.fontMetrics().width(presskey)/2, size.height()/3*2 + 20), presskey);
    
    p.end();
}



#include "TitleScreen.moc"