/*

 Name      :  Plane Deformation
 Notes     :  Plane deformation effects
 
 This is too slow to include.  .05 FPS. Need large lookup table
 
 2D plane deformations using lookup tables was a great way to get
 smooth animations of complex calculations running on slower processors.
 These effects were very common in the 90s demoscene. The idea was to
 take a texture and deform it using a pre-calculated math reference table.
 Different formulas gave different effects such as fake 3d tunnels,
 wormholes and landscapes. Based on formulas by Inigo Quilez.
 
 references:
 http://iquilezles.org/www/material/deform/deform.htm

 */

/*
void deform(int x, int y, int w, int h,int effectStyle){
  byte timeDisplacement=1;  // number of frames to run
  byte page=0;              // double buffer counter

  for (timeDisplacement = 0; timeDisplacement < 200; timeDisplacement++)
  {
    page = timeDisplacement & 1; // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)
    switchWritePage(page);

    // u and v are euclidean coordinates  
    float u,v = 0; 
    setupIMG(x,y,w,h);
    for(int j = 0; j < h; j++) 
    {
      float y = -1.00 + 2.00*(float)j/(float)h;
      for(int i = 0; i < w; i++) 
      {
        float x = -1.00 + 2.00*(float)i/(float)w;
        float d = sqrt(x*x + y*y);
        float a = atan2(y,x);
        switch(effectStyle) {
        case 1:   // stereographic projection / anamorphosis 
          u = fpu_cos(a)/d;
          v = fpu_sin(a)/d;
          break;
        case 2:  // hypnotic rainbow spiral
          v = fpu_sin(a+fpu_cos(3*d))/(pow(d,.2));
          u = fpu_cos(a+fpu_cos(3*d))/(pow(d,.2));
          break;
        case 3:  // rotating tunnel of wonder
          v = 2/(6*d + 3*x);
          u = a*3/PI;
          break;
        case 4:  // wavy star-burst
          v = (-0.4/d)+.1*fpu_sin(8*a);
          u = .5 + .5*a/PI;
          break;
        case 5:  // hyper-space travel
          u = (0.02*y+0.03)*fpu_cos(a*3)/d;
          v = (0.02*y+0.03)*fpu_sin(a*3)/d;
          break;
        case 6:  // five point magnetic flare
          u = 1/(d+0.5+0.5*fpu_sin(5*a));
          v = a*3/PI;
          break;
        case 7:  // cloud like dream scroll
          u = 0.1*x/(0.11+d*0.5);
          v = 0.1*y/(0.11+d*0.5);
          break;
        case 8:  // floor and ceiling with fade to dark horizon
          u = x/abs(y);
          v = 1/abs(y);
          break;
        case 9:  // hot magma liquid swirl
          u = 0.5*(a)/PI;
          v = fpu_sin(2*d);
          break;
        case 10:  // clockwise flush down the toilet
          v = pow(d,0.1);
          u = (1*a/PI)+d;
          break;
        case 11:  // 3D ball
          v = x*(3-sqrt(4-5*d*d))/(d*d+1);
          u = y*(3-sqrt(4-5*d*d))/(d*d+1);
          break;
        default:  // show texture with no deformation
          u = x;
          v = y;
          break;
        }
        int uu =int(0xFF*u+timeDisplacement);    // to look like its animating, add timeDisplacement
        int vv =int(0xFF*v+timeDisplacement);

        // get the R,G,B values from texture
        byte r = vv&0xFF^uu&0xFF;
        byte g = 0;
        byte b = 0;
        VGA_sendCommand(color(r,g,b));
      }
    }
    VGA_GetResponse();
    switchViewPage(page);
  }
}

*/
