import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class XformInterpolator implements Xform {
	XformChooser xf_a;
	XformChooser xf_b;
	XformChooser xf_i;
	boolean is_null;
	double alpha_a, alpha_b;
	double[] coord_a, coord_b;

	public XformInterpolator(XformChooser xf_a, XformChooser xf_b, double alpha) {
		this.xf_a = xf_a;
		this.xf_b = xf_b;
		this.alpha_a = 1.0 - alpha;
		this.alpha_b = alpha;

		if(xf_a.isXformNull() && xf_b.isXformNull()) {
			is_null = true;
		} else if(xf_b.isXformNull()) {
			xf_i = xf_a;
		} else if(xf_a.isXformNull()) {
			xf_i = xf_b;
		} else if(xf_a.getXform().equals(xf_b.getXform())) {
		// or maybe they are the same type but can't be splined
			System.out.println("shouldn't use XformInterpolator in this situation");
			xf_i = null;
		} else {
			xf_i = null;
		}
	}

	public void iterate(double[] coord) {
		if(xf_i != null) {
			xf_i.iterate(coord);
		} else {
			if(is_null) return;
			if(coord_a == null) {
				coord_a = new double[coord.length];
				coord_b = new double[coord.length];
			}
			for(int i=0; i<coord.length; i++)
				coord_a[i] = coord_b[i] = coord[i];
			xf_a.iterate(coord_a);
			xf_b.iterate(coord_b);
			for(int i=0; i<coord.length; i++)
				coord[i] = coord_a[i]*alpha_a + coord_b[i]*alpha_b;
		}
	}

	public String getLabel() { return "Xform Interpolator"; }
	public JPanel getGUI() { return null; }
	public boolean isXformNull() { return is_null; }

	public String toString() {
		return "XformInterpolator["+
			(xf_a==null ? "null" : xf_a.toString())+","+
			(xf_b==null ? "null" : xf_b.toString())+"]";
	}
}
