public class XformZPoly extends XformSkeleton {
	double[] a = new double[6];

	public XformZPoly(ParameterListener listener) {
		init(listener, "a*(x+yi)^2 + b*(x+yi) + c", new String[] {
			"Re(a)", "Im(a)", "Re(b)", "Im(b)", "Re(c)", "Im(c)"
		}, new double[] {
			-2,2,0, -2,2,0, -2,2,1, -2,2,0, -2,2,0, -2,2,0,
		});
	}

	public String getLabel() { return "Complex Polynomial 2D"; }

	public void setXFDoubles(double[] v) {
		a = v;
	}

	public void iterate(double[] z) {
		double z_re = z[0];
		double z_im = z[1];
		double z2_re = z_re*z_re - z_im*z_im;
		double z2_im = 2*z_re*z_im;
		z[0] =
			  z2_re*a[0] + z_re*a[2] + a[4]
			- z2_im*a[1] - z_im*a[3];
		z[1] =
			  z2_im*a[0] + z_im*a[2]
			+ z2_re*a[1] + z_re*a[3] + a[5];
		for(int i=2; i<z.length; i++) z[i] = 0;
	}
}
