import java.util.*;

public abstract class AllParamsSerializer {
	public static String freeze(XformChooser[] xforms, 
	GenOptionsPanel gen_options, DispOptionsPanel disp_options) {
		String s = "";
		for(int i=0; i<xforms.length; i++) {
			s += "XFORM_" + i + "\n";
			s += IndentReader.addTabToEveryLine(xforms[i].freeze());
		}
		s += "GEN_OPTIONS" + "\n";
		s += IndentReader.addTabToEveryLine(gen_options.freeze());
		s += "DISP_OPTIONS" + "\n";
		s += IndentReader.addTabToEveryLine(disp_options.freeze());
		return s;
	}

	public static void thaw(String param_string, XformChooser[] xforms,
	GenOptionsPanel gen_options, DispOptionsPanel disp_options) throws Exception {
		HashMap<String, String> param_map = IndentReader.readIndentString(param_string);
		for(int i=0; i<xforms.length; i++)
			xforms[i].thaw(param_map.get("XFORM_"+i));
		gen_options.thaw(param_map.get("GEN_OPTIONS"));
		disp_options.thaw(param_map.get("DISP_OPTIONS"));
	}
}
