import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.event.*;
import javax.swing.*;

public class CheckboxParameter 
implements AdjustableParameter, ActionListener {
	ArrayList<ParameterListener> listeners = new ArrayList<ParameterListener>();
	JCheckBox checkbox;
	JComponent gui;
	String id;
	String label;
	String tooltip;
	boolean state;
	boolean ignore_events;

	public CheckboxParameter(String id, boolean state) {
		this(id, id, state);
	}

	public CheckboxParameter(String id, String label, boolean state) {
		this(id, label, null, state);
	}

	public CheckboxParameter(String id, String label, String tooltip, boolean state) {
		this.id = id;
		this.label = label;
		this.tooltip = tooltip;
		this.state = state;
	}

	public void addParameterListener(ParameterListener l) {
		listeners.add(l);
	}

	public void removeParameterListener(ParameterListener l) {
		listeners.remove(l);
	}

	public JComponent createGUIComponent() {
		if(gui != null) return gui;

		checkbox = new JCheckBox(label, state);
		checkbox.addActionListener(this);

		this.gui = checkbox;
		return gui;
	}

	public String getID() { return id; }

	public String getLabel() { return label; }
	
	public String getTooltip() { return tooltip; }

	public void setParams(Object p) {
		syncNewValue(((Boolean)p).booleanValue(), true);
	}

	public Object getParams() {
		return new Boolean(state);
	}

	public Object[] interpolate(Object[] seq_obj, double pos_f) {
		int pos = (int)Math.floor(pos_f);
		Boolean left_obj = (Boolean)( 
			pos < 0 ? seq_obj[0] :
			pos >= seq_obj.length ? seq_obj[seq_obj.length-1] :
			seq_obj[pos]);
		pos++;
		Boolean right_obj = (Boolean)(
			pos < 0 ? seq_obj[0] :
			pos >= seq_obj.length ? seq_obj[seq_obj.length-1] :
			seq_obj[pos]);
		if(right_obj.equals(left_obj)) right_obj = left_obj;
		return new Object[] { left_obj, right_obj };
	}

	public void mutate(AdjustableParameter source, 
	double exp, double mult, boolean allow_gaps) {
		try {
			setParams(source.getParams());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public String freeze() { return ""+state; }

	public void thaw(String s) throws Exception {
		boolean v = s.equals("true");
		syncNewValue(new Boolean(v), true);
	}

	private void syncNewValue(boolean val, boolean notify_listeners) {
//System.out.println("id="+id+", state="+val);
		state = val;
		ignore_events = true; // prevent feedback...
		if(checkbox != null) {
			checkbox.setSelected(state);
		}
		ignore_events = false;
		if(notify_listeners) {
			for(ParameterListener l : listeners) {
				l.parameterChanged(this);
			}
		}
	}

	public void actionPerformed(ActionEvent evt) {
		if(ignore_events) return;
		syncNewValue(checkbox.isSelected(), true);
	}
}
