//[VERT]
attribute vec2 position;
attribute vec2 texCoord0;

varying vec2 vTexCoord0;

void main()
{
	gl_Position = vec4(position.x, position.y, 0.0, 1.0);
	vTexCoord0 = texCoord0;
}

//[FRAG]
#version 120

uniform sampler2D tex0;
uniform float ds;//default=1.0
uniform float dt;//default=0.0
varying vec2 vTexCoord0;

vec4 gauss(sampler2D tex, vec2 origin, vec2 d)
{
	vec4 color;

	color +=  0.01 * texture2D(tex, origin + (-5.0*d));
	color +=  0.05 * texture2D(tex, origin + (-4.0*d));
	color +=  0.09 * texture2D(tex, origin + (-3.0*d));
	color +=  0.12 * texture2D(tex, origin + (-2.0*d));
	color +=  0.15 * texture2D(tex, origin + (-1.0*d));
	color +=  0.16 * texture2D(tex, origin);
	color +=  0.15 * texture2D(tex, origin + ( 1.0*d));
	color +=  0.12 * texture2D(tex, origin + ( 2.0*d));
	color +=  0.09 * texture2D(tex, origin + ( 3.0*d));
	color +=  0.05 * texture2D(tex, origin + ( 4.0*d));
	color +=  0.01 * texture2D(tex, origin + ( 5.0*d));

	return color;
}

void main()
{
	gl_FragColor = gauss(tex0, vTexCoord0, vec2(ds, dt));
}