//[VERT]
attribute vec3 position;
attribute vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

varying vec3 vTexCoord0;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);		
	vTexCoord0 = normalize(position);
}

//[FRAG]
uniform samplerCube envMap;
varying vec3 vTexCoord0;

void main()
{
	gl_FragColor = textureCube(envMap, vTexCoord0);
}
