//[VERT]
attribute vec2 position;
attribute vec2 texCoord0;

varying vec2 vTexCoord0;

void main()
{
	gl_Position = vec4(position.x, position.y, 0.0, 1.0);
	vTexCoord0 = texCoord0;
}

//[FRAG]

/*
float LinearizeDepth(vec2 uv)
			{
				float n = 1.0;
				float f = 100.0;
				float z = texture2D(depthTex, uv).x;
				return (2.0 * n) / (f + n - z * (f - n));	
			}
							
			void main() 
			{ 
				vec2 uv = gl_TexCoord[0].xy;
				float d = LinearizeDepth(uv);
				float centre = LinearizeDepth(vec2(0.5, 0.5));
				d = clamp(abs(centre - d) * 3.0, 0.0, 1.0);
				
				gl_FragColor = mix(texture2D(sceneTex, uv), texture2D(blurTex, uv), d);//vec4(d, d, d, 1.0);//
			}
*/			
			

//#version 120

uniform sampler2D tex0;
uniform sampler2D blurredTex1;
uniform sampler2D depthTex2;
uniform float focalDistance;
uniform float focalRange;

varying vec2 vTexCoord0;

float LinearizeDepth(vec2 uv) {
	float n = 2.0;
	float f = 240.0;
	float z = texture2D(depthTex2, uv).x;
	return (5.0 * n) / (f + n - z * (f - n));	
}
			
void main()
{
	vec4 depth = texture2D(depthTex2, vTexCoord0);
	vec4 color = texture2D(tex0, vTexCoord0);
	vec4 blur = texture2D(blurredTex1, vTexCoord0);
	
	float d = LinearizeDepth(vTexCoord0);
	float centre = .2;//focalDistance;//LinearizeDepth(vec2(0.5, 0.5));
	d = clamp(abs(centre - d) * 3.0, 0.0, 1.0);
	
	gl_FragColor = mix(color, blur, d);
	//gl_FragColor = vec4(d);
	//gl_FragColor = depth;
}