//[VERT]
attribute vec2 position;
attribute vec2 texCoord0;

varying vec2 vTexCoord0;

void main()
{
	gl_Position = vec4(position.x, position.y, 0.0, 1.0);
	vTexCoord0 = texCoord0;
}

//[FRAG]
uniform sampler2D baseTex;
uniform sampler2D blendTex;
uniform float invertT;
varying vec2 vTexCoord0;

void main()
{
	vec2 st;
	if (invertT < 0.0) {
		st = vec2(vTexCoord0.s, 1.0-vTexCoord0.t);
	}
	else {
		st = vTexCoord0;
	}
	
	vec4 base = texture2D(baseTex, st);	
	vec4 blend = texture2D(blendTex, st);	
	gl_FragColor = vec4(1.0) - (vec4(1.0) - base) / blend; //color burn
}
