//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec3 flatNormal;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

varying vec3 vNormal;
varying vec3 vFlatNormal;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vNormal = normal;
	vFlatNormal = flatNormal;
}

//[FRAG]

uniform vec3 color1;
uniform vec3 color2;

varying vec3 vNormal;
varying vec3 vFlatNormal;

void main()
{
	float NdotSky = dot(vNormal, vec3(0.0,1.0,0.0));	
	NdotSky *= 1.5;
	float k = (NdotSky + 1.0) / 2.0;
	
	float fNdotL = dot(normalize(vFlatNormal), normalize(vec3(3.0, 3.0, 3.0)));
	if (fNdotL < 0.0) {
		fNdotL = 0.0;//1.0 + fNdotL;
	}	
	
	vec3 color  = mix(color1, color2, k);
	
	//gl_FragColor.rgb = color * vec3(0.95 + 0.05*fNdotL) * 1.2;
	gl_FragColor.rgb = color * vec3(0.9 + 0.1*fNdotL) * 1.2;
	//gl_FragColor.rgb = vec3(0.5 + 0.5*fNdotL);
}
