//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec2 texCoord0;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform vec3 camPos;

varying vec2 texCoord0Var;
varying vec3 vNormal;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	texCoord0Var = texCoord0;	
	vNormal = position;
}

//[FRAG]
varying vec2 texCoord0Var;
uniform sampler2D tex0;
uniform float alpha;
varying vec3 vNormal;

void main()
{
	gl_FragColor = texture2D(tex0, texCoord0Var);
	//gl_FragColor *= vec4(0.5) + 0.5*vec4(normalize(vNormal), 1.0);
	//gl_FragColor *= vec4(0.5, 0.5, 0.0, 0.0);// + 0.5*vec4(normalize(vNormal), 1.0);
	gl_FragColor.rgb *= vec3(0.90) + 0.1*normalize(vec3(vNormal.x, 0.0, vNormal.y));
	gl_FragColor.a = alpha;
}
