/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import sumo.gui.Icons;
import sumo.gui.PluginPanel;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.lines.BasicLine;
import sumo.gui.lines.LineIF;
import sumo.plugin.PluginIF;
import sumo.project.Project;

public class AbstractLine {
    public PluginIF plugin;
    public LineIF drawableLine;
    boolean isMinimized = false;
    int level = 0;
    public ArrayList<AbstractLine> childs;
    private boolean hasMouseMarkListeners = false;
    boolean showChilds = false;
    private int type;
    private String title = "";
    public static final int TYPE_BASIC = 0;
    public static final int TYPE_PLUGIN_TITLE = 1;
    public static final int TYPE_PLUGIN_SUBTITLE = 2;
    public PluginPanel pluginPanel;

    public AbstractLine(PluginPanel pluginPanel, PluginIF plug, int type, String title, guiLineTypeIF vc) {
        this.title = title;
        this.pluginPanel = pluginPanel;
        this.type = type;
        this.plugin = plug;
        this.childs = new ArrayList();
        this.isMinimized = plug.isMinimized();
        this.drawableLine = new BasicLine(this);
        this.drawableLine.setValueControler(vc);
        if (vc != null) {
            this.drawableLine.setKeyFramePanel(vc.getKeyFramePanel(pluginPanel.getScenePanel()));
        }
        this.drawableLine.getButtonMinimize().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                AbstractLine.this.isMinimized = !AbstractLine.this.isMinimized;
                AbstractLine.this.rebuildPluginPanel();
                AbstractLine.this.refreshMinimizedButton();
            }
        });
        this.refreshMinimizedButton();
    }

    private void refreshMinimizedButton() {
        if (this.drawableLine != null && this.drawableLine.getButtonMinimize() != null) {
            if (this.isMinimized) {
                this.drawableLine.getButtonMinimize().setIcon(Icons.ICON_FOLDER_CLOSE);
            } else {
                this.drawableLine.getButtonMinimize().setIcon(Icons.ICON_FOLDER_OPEN);
            }
            this.drawableLine.getButtonMinimize().repaint();
        }
    }

    public void renderGL() {
        this.plugin.render();
    }

    public void rebuildPluginPanel() {
        Project.getProject();
        if (Project.guimode) {
            this.pluginPanel.rebuildPluginComponents();
            this.plugin.setMinimized(this.isMinimized);
        }
    }

    public int addToComponent(PluginPanel pluginPanel, int posy, int level) {
        JPanel p = this.drawableLine.getComponent();
        int height = 17;
        if (this.drawableLine != null) {
            height = this.drawableLine.getLineHeight();
        }
        p.setBounds(0, posy, pluginPanel.getWidth(), height);
        posy += p.getHeight();
        pluginPanel.add(p);
        this.level = level;
        if (this.hasChilds()) {
            int count = 0;
            if (!this.isMinimized) {
                for (AbstractLine child : this.childs) {
                    posy = child.addToComponent(pluginPanel, posy, level + 1);
                    ++count;
                }
            }
        }
        return posy;
    }

    public boolean hasChilds() {
        return this.childs.size() > 0;
    }

    public int getLevel() {
        return this.level;
    }

    public String getTitle() {
        if (this.type == 1 && this.plugin != null && this.plugin.getSubTitle() != null) {
            return this.title + ": " + this.plugin.getSubTitle();
        }
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public boolean getHasMouseMarkListeners() {
        return this.hasMouseMarkListeners;
    }

    public void setHasMouseMarkListeners(boolean b) {
        this.hasMouseMarkListeners = b;
    }
}

