/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.lwjgl.opengl.GL11;
import sumo.gui.Icons;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.util.stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugDetail
extends DetailEmpty
implements DetailIF {
    public static boolean doDebug = false;
    static JList list;
    DetailButton debug;
    static JLabel errorlabel;
    static JLabel errorlabel2;

    @Override
    public void dispose() {
    }

    public DebugDetail() {
        this.setTitle(this, "debug ");
        this.setSize(270, 300);
        this.setLayout(null);
        this.debug = new DetailButton(Icons.ICON_NONE, "debug: " + doDebug);
        Area area = new Area("debug", this, Area.LAYOUT_ONE);
        area.addLine(this.debug);
        this.addArea(area);
        errorlabel = new JLabel();
        errorlabel.setBounds(10, 100, 250, 20);
        errorlabel.setText("no error");
        this.add(errorlabel);
        errorlabel2 = new JLabel();
        errorlabel2.setBounds(10, 115, 250, 20);
        errorlabel2.setText("");
        this.add(errorlabel2);
        list = new JList();
        list.setVisibleRowCount(3);
        JScrollPane js = new JScrollPane(list);
        js.setBounds(10, 140, 250, 200);
        this.add(js);
        this.debug.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                doDebug = !doDebug;
                DebugDetail.this.updateDebugButton();
            }
        });
    }

    void updateDebugButton() {
        this.debug.setTitle("debug: " + doDebug);
    }

    public static void setWatches(ArrayList<stopwatch> watches) {
        String s = "";
        if (watches == null) {
            return;
        }
        list.setListData(watches.toArray());
    }

    public static void checkGLError(String s) {
        int er;
        if (doDebug && (er = GL11.glGetError()) != 0) {
            String t = "";
            if (er == 1280) {
                t = "GL_INVALID_ENUM (GLenum argument out of range)";
            }
            if (er == 1281) {
                t = "GL_INVALID_VALUE (Numeric argument out of range)";
            }
            if (er == 1282) {
                t = "GL_INVALID_OPERATION (Operation illegal in current state)";
            }
            if (er == 1283) {
                t = "GL_STACK_OVERFLOW (Command would cause a stack overflow)";
            }
            if (er == 1284) {
                t = "GL_STACK_UNDERFLOW (Command would cause a stack underflow)";
            }
            if (er == 1285) {
                t = "GL_OUT_OF_MEMORY";
            }
            t = "OPENGL ERROR (" + er + ") " + t;
            errorlabel.setText(t);
            errorlabel2.setText(s);
            errorlabel.setForeground(Color.red);
            errorlabel2.setForeground(Color.red);
            System.out.println(t + s);
        }
    }
}

