/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.Elements;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import sumo.timing.timerFMOD;
import sumoTween.Tweener;

public class SpectrumPanel
extends JPanel {
    static Tweener tweener;
    boolean isDragging = false;
    int mouseX = 0;
    int startX = 0;
    int endX = 0;
    int startY = 0;
    int Yheight = 0;

    public void setStartX(int x) {
        this.startX = x / 2;
    }

    public void setEndX(int x) {
        this.endX = x / 2;
    }

    public SpectrumPanel(Tweener tweenerr) {
        tweener = tweenerr;
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
                SpectrumPanel.this.isDragging = false;
            }

            public void mousePressed(MouseEvent e) {
                SpectrumPanel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                SpectrumPanel.this.mouseX = e.getX();
            }

            public void mouseDragged(MouseEvent e) {
                if (!SpectrumPanel.this.isDragging) {
                    SpectrumPanel.this.startX = e.getX();
                }
                SpectrumPanel.this.endX = e.getX();
                SpectrumPanel.tweener.FFTSpectrumStart = SpectrumPanel.this.startX * 2;
                SpectrumPanel.tweener.FFTSpectrumEnd = SpectrumPanel.this.endX * 2;
                SpectrumPanel.this.isDragging = true;
            }
        });
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.darkGray);
        g.fillRect(this.startX, 0, Math.abs(this.startX - this.endX), this.getHeight());
        if (timerFMOD.spectrum != null) {
            for (int i = 0; i < timerFMOD.spectrum.capacity(); i += 2) {
                int v = (int)(timerFMOD.spectrum.get(i) * (float)this.getHeight());
                if (i / 2 > this.startX && i / 2 < this.endX) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.gray);
                }
                g.fillRect(i / 2, this.getHeight() - v - 1, 1, v);
            }
        }
        g.setColor(Color.green);
        g.drawLine(0, this.startY, this.getWidth(), this.startY);
        g.drawLine(0, this.startY - this.Yheight, this.getWidth(), this.startY - this.Yheight);
        g.setColor(Color.red);
        g.drawRect(this.startX, this.startY - this.Yheight, Math.abs(this.startX - this.endX), this.Yheight);
    }

    public void setTop(float value) {
        this.startY = (int)(value * (float)this.getHeight());
        this.repaint();
    }

    public void setYHeight(float value) {
        this.Yheight = (int)(value * (float)this.getHeight());
        this.repaint();
    }
}

