/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lineTypeElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.AbstractLine;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.keyframeable.FloatDetail;
import sumo.gui.lineTypeElements.ValueChangedListener;
import sumo.gui.lineTypeElements.ValueEvent;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.project.Project;
import sumoTween.Tweener;
import sumoTween.events.TweenEvent;

public class guiFloat
extends JPanel
implements guiLineTypeIF {
    private int defaultEasingDir = 2;
    private float startValue = 0.0f;
    private int mouseStartX = 0;
    private float oldvalue = 0.0f;
    private boolean mouseDragging = false;
    float value = 1.0f;
    private Vector<ValueChangedListener> valueChangedListeners = new Vector();
    Tweener theFloat;
    private boolean mouseOver = false;
    Color fgColor = Settings.mainColor2;
    private boolean setDetail = true;
    Color bgColor = Settings.lineBackground;
    public boolean drawBottomBorder = true;
    guiStopWatch watch = null;
    private KeyFramePanel keyframepanel;
    AbstractLine abstractLine = null;
    private boolean enabledisable = false;

    public guiFloat(Tweener f) {
        this(f, true);
    }

    public guiFloat(Tweener f, boolean setDetail) {
        this.setDetail = setDetail;
        this.init();
        this.theFloat = f;
        f.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                if (guiFloat.this.keyframepanel != null) {
                    guiFloat.this.keyframepanel.setkeys(guiFloat.this.theFloat);
                    guiFloat.this.keyframepanel.repaint();
                }
                guiFloat.this.repaint();
            }

            public void finished() {
            }
        });
    }

    public guiFloat() {
        this.init();
    }

    void init() {
        this.setBounds(new Rectangle(103, 16));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (guiFloat.this.setDetail) {
                    Project.getProject().setDetailPanel(new FloatDetail(guiFloat.this.theFloat, guiFloat.this.abstractLine));
                }
            }

            public void mouseEntered(MouseEvent e) {
                guiFloat.this.mouseOver = true;
                guiFloat.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                guiFloat.this.mouseOver = false;
                guiFloat.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                guiFloat.this.mouseOver = false;
                guiFloat.this.mouseDragging = false;
                guiFloat.this.oldvalue = 0.0f;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                guiFloat.this.mouseDragging = true;
                if (guiFloat.this.oldvalue == 0.0f) {
                    guiFloat.this.oldvalue = guiFloat.this.value;
                }
                guiFloat.this.value = guiFloat.this.oldvalue - ((float)guiFloat.this.mouseStartX - (float)e.getX()) / (float)guiFloat.this.getWidth();
                if (guiFloat.this.value > 1.0f) {
                    guiFloat.this.value = 1.0f;
                } else if (guiFloat.this.value < 0.0f) {
                    guiFloat.this.value = 0.0f;
                }
                if (Float.isNaN(guiFloat.this.value)) {
                    guiFloat.this.value = 0.0f;
                }
                if (Float.isNaN(guiFloat.this.oldvalue)) {
                    guiFloat.this.oldvalue = 0.0f;
                }
                guitest.setStatus(String.valueOf(guiFloat.this.value) + "");
                guiFloat.this.notifyValueChangedListeners();
                if (guiFloat.this.theFloat != null) {
                    guiFloat.this.theFloat.set(Project.getProject().getTime(), guiFloat.this.value, guiFloat.this.defaultEasingDir);
                }
                guiFloat.this.mouseOver = true;
                guiFloat.this.repaint();
                if (guiFloat.this.keyframepanel != null) {
                    guiFloat.this.keyframepanel.repaint();
                }
            }

            public void mouseMoved(MouseEvent e) {
                guiFloat.this.mouseStartX = e.getX();
            }
        });
        if (this.keyframepanel != null) {
            // empty if block
        }
    }

    public void setFnColor(Color c) {
        this.fgColor = c;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(2);
        }
        if (this.keyframepanel != null && this.keyframepanel.getNumKeys() != this.theFloat.getNumKeys()) {
            System.out.println(this.keyframepanel.getNumKeys() + "!=" + this.theFloat.getNumKeys());
            this.keyframepanel.setkeys(this.theFloat);
            this.keyframepanel.repaint();
        }
        float valueFFT = 0.0f;
        if (this.theFloat != null) {
            this.value = this.theFloat.getValueWithoutFFT();
            valueFFT = this.theFloat.getValueFFT();
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(this.bgColor);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.theFloat.isEnabled()) {
            gd.setColor(this.bgColor);
            gd.setColor(Settings.pluginTitleBackground);
            gd.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 3);
            int valuePixel = (int)((float)(this.getWidth() - 5) * this.value);
            int valueStartPixel = 2;
            if (this.startValue != 0.0f) {
                valueStartPixel = 2 + (int)((float)(this.getWidth() - 5) * this.startValue);
            }
            gd.setColor(this.fgColor);
            gd.fillRect(valueStartPixel, 1, valuePixel -= valueStartPixel, this.getHeight() - 5);
            if (this.theFloat.useFFT) {
                gd.setColor(Color.white);
                gd.drawRect(valueStartPixel, 1, (int)((float)(this.getWidth() - 5) * valueFFT), this.getHeight() - 6);
            }
            gd.setColor(Color.black);
            gd.setFont(Settings.smallfont);
            if (String.valueOf(this.value).length() > 6) {
                gd.drawString("" + String.valueOf(this.value).substring(0, 6), 5, 10);
            } else {
                gd.drawString("" + String.valueOf(this.value), 5, 10);
            }
        }
        if (this.drawBottomBorder) {
            gd.setColor(Color.WHITE);
            gd.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private void notifyValueChangedListeners() {
        ValueEvent e = new ValueEvent(this, this.value);
        for (int x = 0; x < this.valueChangedListeners.size(); ++x) {
            ValueChangedListener target = this.valueChangedListeners.elementAt(x);
            target.valueChanged(e);
        }
    }

    public Tweener getTheFloat() {
        return this.theFloat;
    }

    public void setTheFloat(Tweener theFloat) {
        this.theFloat = theFloat;
    }

    public void addValueChangedListener(ValueChangedListener l) {
        if (this.valueChangedListeners.contains(l)) {
            return;
        }
        this.valueChangedListeners.addElement(l);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (value < 0.0f) {
            value = 0.0f;
        }
        this.theFloat.set(Project.getProject().getTime(), value, this.defaultEasingDir);
    }

    public float getStartValue() {
        return this.startValue;
    }

    public void setStartValue(float startValue) {
        this.startValue = startValue;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isKeyframeAble() {
        return true;
    }

    public boolean isKeyFramed() {
        return this.theFloat.isKeyframed();
    }

    public void setIsKeyFramed(boolean b) {
        this.theFloat.setKeyframed(b);
        this.notifyValueChangedListeners();
    }

    public Tweener getKeyframed() {
        return this.theFloat;
    }

    public KeyFramePanelIF getKeyFramePanel(ScenePanel p) {
        if (this.keyframepanel == null) {
            this.keyframepanel = new KeyFramePanel(p);
        }
        return this.keyframepanel;
    }

    public void setAbstractLine(AbstractLine al) {
        this.abstractLine = al;
    }

    public void setEnableDisableSwitch(boolean enabledisable) {
        this.enabledisable = enabledisable;
        System.out.println("enabledisable:" + enabledisable);
    }

    public boolean getEnableDisableSwitch() {
        return this.enabledisable;
    }
}

